/*
 * Decompiled with CFR 0.152.
 */
package fr.okteo.simoc.xml.V2;

import com.teamlog.simoc.xml.MsgErr;
import com.teamlog.simoc.xml.Utils;
import fr.okteo.simoc.xmlObject.V2.Adresse;
import fr.okteo.simoc.xmlObject.V2.Anomalie;
import fr.okteo.simoc.xmlObject.V2.Chargement;
import fr.okteo.simoc.xmlObject.V2.Circulation;
import fr.okteo.simoc.xmlObject.V2.CirculationOrienteeChargement;
import fr.okteo.simoc.xmlObject.V2.CirculationOrienteeDechargement;
import fr.okteo.simoc.xmlObject.V2.CodeAcquisition;
import fr.okteo.simoc.xmlObject.V2.CodeActionEvenement;
import fr.okteo.simoc.xmlObject.V2.CodeEspece;
import fr.okteo.simoc.xmlObject.V2.Collecte;
import fr.okteo.simoc.xmlObject.V2.Dechargement;
import fr.okteo.simoc.xmlObject.V2.Destination;
import fr.okteo.simoc.xmlObject.V2.DetailAnomalie;
import fr.okteo.simoc.xmlObject.V2.Immatriculation;
import fr.okteo.simoc.xmlObject.V2.NotificationMouvementLotOvinCaprin;
import fr.okteo.simoc.xmlObject.V2.NumeroAnimal;
import fr.okteo.simoc.xmlObject.V2.OCAnomalyCodeType;
import fr.okteo.simoc.xmlObject.V2.OCRegistrationIdentifiantTypeType;
import fr.okteo.simoc.xmlObject.V2.Organisation;
import fr.okteo.simoc.xmlObject.V2.OrganisationTransport;
import fr.okteo.simoc.xmlObject.V2.Party;
import fr.okteo.simoc.xmlObject.V2.Personne;
import fr.okteo.simoc.xmlObject.V2.Provenance;
import fr.okteo.simoc.xmlObject.V2.Registration;
import fr.okteo.simoc.xmlObject.V2.TypeIdentifiantNumeroAnimal;
import fr.okteo.simoc.xmlObject.V2.Validation;
import fr.okteo.simoc.xmlObject.V2.Vehicule;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;

public class ControleV2 {
    private static final String FILE_NAME = "codes-references";
    private static final String FILE_NAME_FIN_HABILTATION = "codes-references-fin-habilitation";
    private static final String TYPE_BELVR = "BELVR";
    private static final String TYPE_BOPAV = "BOPAV";
    private static final String TYPE_BLIPG = "BLIPG";
    private static final String TYPE_BDELG = "BDELG";
    private static final String TYPE_BNSIMOC = "BNSIMOC";
    private static final String TYPE_BDNI = "BDNI";
    private static final String TYPE_BNOVINFOS = "BNOVINFOS";
    private static final String TYPE_BPOVINFOS = "BPOVINFOS";
    private static final String IMMA_NUM_EXPLOIT = "NumeroExploitation";
    private static final String IMMA_NUM_AGREMENT = "NumeroAgrementSanitaire";
    private static final String IMMA_CODE_MOIPG = "CodeMOIPG";
    private static final String IMMA_NUM_DELEGATAIRE = "NumeroStructureDelegataire";
    private static final String IMMA_NUM_SIREN = "NumeroSIREN";
    private static final String IMMA_CERTIF_UE = "CertificatUE";
    private static final String IMMA_CERTIF_PAYS_TIERS = "CertificatPaysTiers";
    private static final String CATEGORIE_ACTEUR_10 = "10";
    private static final String CATEGORIE_ACTEUR_20 = "20";
    private static final String CATEGORIE_ACTEUR_31 = "31";
    private static final String CATEGORIE_ACTEUR_32 = "32";
    private static final String CATEGORIE_ACTEUR_34 = "34";
    private static final String CATEGORIE_ACTEUR_40 = "40";
    private static final String TYPE_NUM_DDSV = "NumeroDDSV";
    private static final String INCONNU = "INCONNU";
    private static final String ETRANGER = "ETRANGER";
    private static final String NUM_INEXISTANT = "Numero Inexistant";
    private static final String OVINFOS = "OVINFOS";
    private static XMLGregorianCalendar dateCreation = null;
    private static List<String> codesEmetteur = null;
    private static List<String> codesCreateur = null;
    private static HashMap<String, List<String>> emmetteursCreateurs = null;

    public static boolean VerifierCoherence(NotificationMouvementLotOvinCaprin mvtOC, List<String> erreursEntete, String nomFichier, String versionSchemaReference, Boolean dateV2depassee) {
        List<Circulation> lst;
        int nbErr = 0;
        erreursEntete.clear();
        dateCreation = mvtOC.getCreation();
        ControleV2.ControlerEntete(mvtOC, erreursEntete, nomFichier, versionSchemaReference);
        ControleV2.ControleBalisesGenerales(mvtOC, versionSchemaReference, dateV2depassee);
        if (mvtOC.getCirculationOrienteeChargement() != null && !mvtOC.getCirculationOrienteeChargement().isEmpty()) {
            lst = mvtOC.getCirculationOrienteeChargement();
            for (CirculationOrienteeChargement circulationOrienteeChargement : lst) {
                if (!CodeActionEvenement.CRE.equals((Object)circulationOrienteeChargement.getCodeAction())) continue;
                ControleV2.ControlerCirculationOrienteeChargement(circulationOrienteeChargement, versionSchemaReference);
            }
        }
        if (mvtOC.getCirculationOrienteeDechargement() != null && !mvtOC.getCirculationOrienteeDechargement().isEmpty()) {
            lst = mvtOC.getCirculationOrienteeDechargement();
            for (CirculationOrienteeDechargement circulationOrienteeDechargement : lst) {
                if (!CodeActionEvenement.CRE.equals((Object)circulationOrienteeDechargement.getCodeAction())) continue;
                ControleV2.ControlerCirculationOrienteeDechargement(circulationOrienteeDechargement, versionSchemaReference);
            }
        }
        if (mvtOC.getCollecte() != null) {
            List<Collecte> collectes = mvtOC.getCollecte();
            for (Collecte collecte : collectes) {
                nbErr += collecte.getValidation().getAnomalie().size();
            }
        }
        if (mvtOC.getCirculationOrienteeChargement() != null) {
            lst = mvtOC.getCirculationOrienteeChargement();
            for (CirculationOrienteeChargement circulationOrienteeChargement : lst) {
                nbErr += circulationOrienteeChargement.getValidation().getAnomalie().size();
            }
        }
        if (mvtOC.getCirculationOrienteeDechargement() != null) {
            lst = mvtOC.getCirculationOrienteeDechargement();
            for (CirculationOrienteeDechargement circulationOrienteeDechargement : lst) {
                nbErr += circulationOrienteeDechargement.getValidation().getAnomalie().size();
            }
        }
        mvtOC.setNbEvtErreur(nbErr);
        if (nbErr > 0) {
            mvtOC.setFichierRejete(true);
        } else {
            mvtOC.setFichierRejete(false);
        }
        return mvtOC.isFichierRejete() == false && erreursEntete.size() == 0;
    }

    public static void PreparerReponse(NotificationMouvementLotOvinCaprin mvtOC) {
        Organisation createur;
        List<Circulation> lstCirculation;
        mvtOC.setDocumentOrigine(mvtOC.getIdentification());
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTimeInMillis(System.currentTimeMillis());
        DatatypeFactory df = null;
        try {
            df = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException e) {
            System.err.println(e.getMessage());
        }
        XMLGregorianCalendar dd = df.newXMLGregorianCalendar(gc);
        dd.setTimezone(0);
        mvtOC.setCreation(dd);
        Party issuer = mvtOC.getIssuer();
        mvtOC.setIssuer(mvtOC.getOwner());
        mvtOC.setOwner(issuer);
        List<Collecte> collectes = mvtOC.getCollecte();
        for (Collecte collecte : collectes) {
            Organisation organisation = collecte.getCreateur();
            collecte.setCreateur(collecte.getDestinataire());
            collecte.setDestinataire(organisation);
        }
        if (mvtOC.getCirculationOrienteeChargement() != null && !mvtOC.getCirculationOrienteeChargement().isEmpty()) {
            lstCirculation = mvtOC.getCirculationOrienteeChargement();
            for (CirculationOrienteeChargement circulationOrienteeChargement : lstCirculation) {
                createur = circulationOrienteeChargement.getCreateur();
                circulationOrienteeChargement.setCreateur(circulationOrienteeChargement.getDestinataire());
                circulationOrienteeChargement.setDestinataire(createur);
            }
        }
        if (mvtOC.getCirculationOrienteeDechargement() != null && !mvtOC.getCirculationOrienteeDechargement().isEmpty()) {
            lstCirculation = mvtOC.getCirculationOrienteeDechargement();
            for (CirculationOrienteeDechargement circulationOrienteeDechargement : lstCirculation) {
                createur = circulationOrienteeDechargement.getCreateur();
                circulationOrienteeDechargement.setCreateur(circulationOrienteeDechargement.getDestinataire());
                circulationOrienteeDechargement.setDestinataire(createur);
            }
        }
    }

    private static void ControlerEntete(NotificationMouvementLotOvinCaprin mvtOC, List<String> erreursEntete, String nomFichier, String versionSchemaReference) {
        Validation validation;
        int nbEnregistrement = 0;
        boolean erreurJG907 = false;
        ControleV2.ControlerIssuerOwner(mvtOC.getIssuer().getRegistration(), mvtOC.getOwner().getRegistration(), erreursEntete, versionSchemaReference);
        if (nomFichier.startsWith("SIMOC_")) {
            List<Circulation> lst;
            if (mvtOC.getDocumentOrigine() != null || mvtOC.isFichierRejete() != null || mvtOC.getNbEvtErreur() != null) {
                erreurJG907 = true;
            }
            if (mvtOC.getCirculationOrienteeChargement() != null && !mvtOC.getCirculationOrienteeChargement().isEmpty()) {
                lst = mvtOC.getCirculationOrienteeChargement();
                for (CirculationOrienteeChargement circulationOrienteeChargement : lst) {
                    if (circulationOrienteeChargement.getValidation() == null || circulationOrienteeChargement.getValidation().getAnomalie() == null && circulationOrienteeChargement.getValidation().isQualification() == null) continue;
                    erreurJG907 = true;
                    break;
                }
            }
            if (mvtOC.getCirculationOrienteeDechargement() != null && !mvtOC.getCirculationOrienteeDechargement().isEmpty()) {
                lst = mvtOC.getCirculationOrienteeDechargement();
                for (CirculationOrienteeDechargement circulationOrienteeDechargement : lst) {
                    if (circulationOrienteeDechargement.getValidation() == null || circulationOrienteeDechargement.getValidation().getAnomalie() == null && circulationOrienteeDechargement.getValidation().isQualification() == null) continue;
                    erreurJG907 = true;
                    break;
                }
            }
            if (mvtOC.getCollecte() != null) {
                List<Collecte> collectes = mvtOC.getCollecte();
                for (Collecte collecte : collectes) {
                    if (collecte.getValidation() == null || collecte.getValidation().getAnomalie() == null && collecte.getValidation().isQualification() == null) continue;
                    erreurJG907 = true;
                    break;
                }
            }
            if (erreurJG907) {
                erreursEntete.add(MsgErr.getMsgErr("JG907", versionSchemaReference));
            }
        }
        if (mvtOC.getIssuer().getRegistration().getIdentifierType().value().equals(TYPE_BDELG)) {
            if (mvtOC.getCirculationOrienteeChargement() != null && !mvtOC.getCirculationOrienteeChargement().isEmpty()) {
                validation = new Validation();
                ControleV2.gestionAnomalie("J060", validation, null, null, versionSchemaReference);
                mvtOC.getCirculationOrienteeChargement().get(0).setValidation(validation);
            }
            if (mvtOC.getCirculationOrienteeDechargement() != null && !mvtOC.getCirculationOrienteeDechargement().isEmpty()) {
                validation = new Validation();
                ControleV2.gestionAnomalie("J060", validation, null, null, versionSchemaReference);
                mvtOC.getCirculationOrienteeDechargement().get(0).setValidation(validation);
            }
        } else if (!(mvtOC.getIssuer().getRegistration().getIdentifierType().value().equals(TYPE_BDELG) || mvtOC.getIssuer().getRegistration().getIdentifierType().value().equals(TYPE_BNOVINFOS) || mvtOC.getCollecte() == null || mvtOC.getCollecte().isEmpty())) {
            validation = new Validation();
            ControleV2.gestionAnomalie("J061", validation, null, null, versionSchemaReference);
            mvtOC.getCollecte().get(0).setValidation(validation);
        }
        if (mvtOC.getCollecte() != null) {
            nbEnregistrement = mvtOC.getCollecte().size();
        }
        if (mvtOC.getCirculationOrienteeChargement() != null && !mvtOC.getCirculationOrienteeChargement().isEmpty()) {
            nbEnregistrement += mvtOC.getCirculationOrienteeChargement().size();
        }
        if (mvtOC.getCirculationOrienteeDechargement() != null && !mvtOC.getCirculationOrienteeDechargement().isEmpty()) {
            nbEnregistrement += mvtOC.getCirculationOrienteeDechargement().size();
        }
        if (mvtOC.getLineCount() != nbEnregistrement) {
            erreursEntete.add(MsgErr.getMsgErr("JG900", versionSchemaReference));
        }
        if (nbEnregistrement > 500) {
            erreursEntete.add(MsgErr.getMsgErr("JG973", versionSchemaReference));
        }
    }

    private static void ControlerIssuerOwner(Registration issuer, Registration onwer, List<String> erreurs, String versionSchemaReference) {
        ControleV2.ControleRegistration(issuer, erreurs, versionSchemaReference);
        ControleV2.ControleRegistration(onwer, erreurs, versionSchemaReference);
        if (issuer.getIdentifierType().value().equals(TYPE_BELVR) && !onwer.getIdentifierType().value().equals(TYPE_BLIPG)) {
            erreurs.add(MsgErr.getMsgErr("JG910", versionSchemaReference));
        }
        if (issuer.getIdentifierType().value().equals(TYPE_BOPAV) && !onwer.getIdentifierType().value().equals(TYPE_BLIPG) && !onwer.getIdentifierType().value().equals(TYPE_BNOVINFOS)) {
            erreurs.add(MsgErr.getMsgErr("JG911", versionSchemaReference));
        }
        if (issuer.getIdentifierType().value().equals(TYPE_BDELG) && !onwer.getIdentifierType().value().equals(TYPE_BNOVINFOS)) {
            erreurs.add(MsgErr.getMsgErr("JG912", versionSchemaReference));
        }
        if (issuer.getIdentifierType().value().equals(TYPE_BLIPG) && !onwer.getIdentifierType().value().equals(TYPE_BNOVINFOS)) {
            erreurs.add(MsgErr.getMsgErr("JG913", versionSchemaReference));
        }
        if (issuer.getIdentifierType().value().equals(TYPE_BNOVINFOS) && !onwer.getIdentifierType().value().equals(TYPE_BNSIMOC) && !onwer.getIdentifierType().value().equals(TYPE_BNOVINFOS)) {
            erreurs.add(MsgErr.getMsgErr("JG914", versionSchemaReference));
        }
    }

    private static void ControleRegistration(Registration registration, List<String> erreurs, String versionSchemaReference) {
        if (registration.getIdentifierType().value().equals(TYPE_BELVR)) {
            if (!Utils.isIdentifiantNational(registration.getIdentifier())) {
                erreurs.add(MsgErr.getMsgErr("JG995", versionSchemaReference));
            }
        } else if (registration.getIdentifierType().value().equals(TYPE_BOPAV)) {
            if (!Utils.isAgrementSanitaire(registration.getIdentifier())) {
                erreurs.add(MsgErr.getMsgErr("JG994", versionSchemaReference));
            }
        } else if (registration.getIdentifierType().value().equals(TYPE_BLIPG)) {
            if (!codesEmetteur.contains(registration.getIdentifier())) {
                erreurs.add(MsgErr.getMsgErr("JG996", versionSchemaReference));
            }
        } else if (registration.getIdentifierType().value().equals(TYPE_BDELG)) {
            if (!registration.getIdentifier().matches("^FR[0-9a-zA-Z]{9}$")) {
                erreurs.add(MsgErr.getMsgErr("JG997", versionSchemaReference));
            }
        } else if (registration.getIdentifierType().value().equals(TYPE_BNSIMOC)) {
            if (!registration.getIdentifier().equals("031BDN")) {
                erreurs.add(MsgErr.getMsgErr("JG998", versionSchemaReference));
            }
        } else if (registration.getIdentifierType().value().equals(TYPE_BNOVINFOS)) {
            if (!registration.getIdentifier().equals(OVINFOS)) {
                erreurs.add(MsgErr.getMsgErr("JG999", versionSchemaReference));
            }
        } else {
            erreurs.add(MsgErr.getMsgErr("JG993", versionSchemaReference));
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void ControleBalisesGenerales(NotificationMouvementLotOvinCaprin mvtOC, String versionSchemaReference, Boolean dateV2depassee) {
        List<Circulation> lstCirculation;
        List<Immatriculation> immatCreateur;
        boolean identifiantOk;
        int nombre = 0;
        List<Collecte> collectes = mvtOC.getCollecte();
        for (Collecte collecte : collectes) {
            List<Dechargement> dechargements;
            void var7_7;
            Validation validation = collecte.getValidation();
            if (validation == null) {
                Validation validation2 = new Validation();
            }
            boolean numeroDelegataire = false;
            identifiantOk = false;
            immatCreateur = collecte.getCreateur().getImmatriculation();
            for (Immatriculation immatriculation : immatCreateur) {
                if (immatriculation.getTypeIdentifiant().value().equals(IMMA_NUM_DELEGATAIRE) || immatriculation.getTypeIdentifiant().value().equals(TYPE_BNOVINFOS) || immatriculation.getTypeIdentifiant().value().equals(TYPE_BPOVINFOS)) {
                    numeroDelegataire = true;
                }
                if (immatriculation.getIdentifiant().equals(OVINFOS)) {
                    identifiantOk = true;
                    continue;
                }
                if (collecte.getIdentifiant().length() <= immatriculation.getIdentifiant().length() || !immatriculation.getIdentifiant().equals(collecte.getIdentifiant().substring(1, immatriculation.getIdentifiant().length() + 1))) continue;
                identifiantOk = true;
            }
            if (CodeActionEvenement.CRE.equals((Object)collecte.getCodeAction()) && !numeroDelegataire) {
                ControleV2.gestionAnomalie("J062", (Validation)var7_7, null, null, versionSchemaReference);
            }
            if (!identifiantOk) {
                ControleV2.gestionAnomalie("J011", (Validation)var7_7, null, null, versionSchemaReference);
            }
            ControleV2.ControleIssuerCodeAction(mvtOC.getIssuer().getRegistration(), collecte.getCodeAction().value(), (Validation)var7_7, versionSchemaReference);
            if (CodeActionEvenement.CRE.equals((Object)collecte.getCodeAction())) {
                ControleV2.ControleVehicule(collecte.getVehicule(), (Validation)var7_7, versionSchemaReference);
            }
            ControleV2.isIdentifiantOK(collecte.getIdentifiant(), mvtOC.getIssuer().getRegistration(), collecte.getCreateur(), (Validation)var7_7, versionSchemaReference);
            ControleV2.ControleCreateurDestinataire(collecte.getCreateur(), collecte.getDestinataire(), mvtOC.getIssuer().getRegistration(), (Validation)var7_7, versionSchemaReference);
            if (CodeActionEvenement.CRE.equals((Object)collecte.getCodeAction())) {
                ControleV2.ControleOrganisationTransport(collecte.getOrganisationTransport(), (Validation)var7_7, versionSchemaReference);
                ControleV2.ControleOrganisationTransportVehicule(collecte.getOrganisationTransport(), collecte.getVehicule(), (Validation)var7_7, versionSchemaReference);
                ControleV2.ControleDateReceptionAcquisition(collecte.getCreateur(), collecte.getDateReceptionNotification(), (Validation)var7_7, versionSchemaReference);
                ControleV2.ControleModeAcquisition(collecte.getCreateur(), collecte.getModeAcquisition(), (Validation)var7_7, versionSchemaReference);
                ControleV2.ControleCategorieActeurTemoinDelegation(collecte, (Validation)var7_7, versionSchemaReference);
                if (collecte.getDechargement() != null) {
                    dechargements = collecte.getDechargement();
                    for (Dechargement dechargement : dechargements) {
                        ControleV2.ControleTypeIdentifiant(dechargement, (Validation)var7_7, versionSchemaReference);
                        if (!dechargement.getCategorieActeur().equals(CATEGORIE_ACTEUR_10) && !dechargement.getCategorieActeur().equals(CATEGORIE_ACTEUR_20) && !dechargement.getCategorieActeur().equals(CATEGORIE_ACTEUR_31) && !dechargement.getCategorieActeur().equals(CATEGORIE_ACTEUR_32) || ControleV2.ControleNbImmatriculationDechargementJ139(dechargement, versionSchemaReference)) continue;
                        ControleV2.gestionAnomalie("J139", (Validation)var7_7, dechargement.getExploitationDeDechargement(), null, versionSchemaReference);
                    }
                }
            }
            ControleV2.ControleDate(collecte.getDateDebut(), collecte.getHeureDebut(), null, (Validation)var7_7, versionSchemaReference);
            ControleV2.ControleDate(collecte.getDateFin(), collecte.getHeureFin(), null, (Validation)var7_7, versionSchemaReference);
            if (mvtOC.getIssuer().getRegistration().getIdentifierType().value().equals(TYPE_BDELG) && CodeActionEvenement.INV.equals((Object)collecte.getCodeAction())) {
                if (collectes.size() > nombre + 1 && collectes.get(nombre + 1) != null) {
                    if (!CodeActionEvenement.CRE.equals((Object)collectes.get(nombre + 1).getCodeAction()) || !collectes.get(nombre + 1).getIdentifiant().equals(collectes.get(nombre).getIdentifiant())) {
                        ControleV2.gestionAnomalie("J156", (Validation)var7_7, null, null, versionSchemaReference);
                    }
                } else {
                    ControleV2.gestionAnomalie("J156", (Validation)var7_7, null, null, versionSchemaReference);
                }
            }
            if (CodeActionEvenement.CRE.equals((Object)collecte.getCodeAction())) {
                if (collecte.getChargement() != null) {
                    List<Chargement> chargements = collecte.getChargement();
                    for (Chargement chargement : chargements) {
                        ControleV2.ControleChargement(chargement, (Validation)var7_7, versionSchemaReference, dateV2depassee);
                    }
                }
                if (collecte.getDechargement() != null) {
                    dechargements = collecte.getDechargement();
                    for (Dechargement dechargement : dechargements) {
                        ControleV2.ControleDechargement(dechargement, (Validation)var7_7, versionSchemaReference, dateV2depassee);
                    }
                }
            }
            var7_7.setQualification(var7_7.getAnomalie().size() == 0);
            collecte.setValidation((Validation)var7_7);
            ++nombre;
        }
        nombre = 0;
        if (mvtOC.getCirculationOrienteeChargement() != null && !mvtOC.getCirculationOrienteeChargement().isEmpty()) {
            lstCirculation = mvtOC.getCirculationOrienteeChargement();
            for (CirculationOrienteeChargement circulationOrienteeChargement : lstCirculation) {
                Validation validation = circulationOrienteeChargement.getValidation();
                if (validation == null) {
                    validation = new Validation();
                }
                identifiantOk = false;
                immatCreateur = circulationOrienteeChargement.getCreateur().getImmatriculation();
                for (Immatriculation immatriculation : immatCreateur) {
                    if (immatriculation.getIdentifiant().equals(OVINFOS)) {
                        identifiantOk = true;
                        continue;
                    }
                    if (circulationOrienteeChargement.getIdentifiant().length() <= immatriculation.getIdentifiant().length() || !immatriculation.getIdentifiant().equals(circulationOrienteeChargement.getIdentifiant().substring(1, immatriculation.getIdentifiant().length() + 1))) continue;
                    identifiantOk = true;
                }
                if (!identifiantOk) {
                    ControleV2.gestionAnomalie("J011", validation, null, null, versionSchemaReference);
                }
                ControleV2.isIdentifiantOK(circulationOrienteeChargement.getIdentifiant(), mvtOC.getIssuer().getRegistration(), circulationOrienteeChargement.getCreateur(), validation, versionSchemaReference);
                ControleV2.ControleCreateurDestinataire(circulationOrienteeChargement.getCreateur(), circulationOrienteeChargement.getDestinataire(), mvtOC.getIssuer().getRegistration(), validation, versionSchemaReference);
                ControleV2.ControleIssuerCodeAction(mvtOC.getIssuer().getRegistration(), circulationOrienteeChargement.getCodeAction().value(), validation, versionSchemaReference);
                if (CodeActionEvenement.CRE.equals((Object)circulationOrienteeChargement.getCodeAction())) {
                    ControleV2.ControleVehicule(circulationOrienteeChargement.getVehiculeUtilise(), validation, versionSchemaReference);
                    ControleV2.ControleOrganisationTransport(circulationOrienteeChargement.getOrganisationTransport(), validation, versionSchemaReference);
                    ControleV2.ControleOrganisationTransportVehicule(circulationOrienteeChargement.getOrganisationTransport(), circulationOrienteeChargement.getVehiculeUtilise(), validation, versionSchemaReference);
                    ControleV2.ControleDateReceptionAcquisition(circulationOrienteeChargement.getCreateur(), circulationOrienteeChargement.getDateReceptionNotification(), validation, versionSchemaReference);
                    ControleV2.ControleModeAcquisition(circulationOrienteeChargement.getCreateur(), circulationOrienteeChargement.getModeAcquisition(), validation, versionSchemaReference);
                }
                if ((mvtOC.getIssuer().getRegistration().getIdentifierType().value().equals(TYPE_BELVR) || mvtOC.getIssuer().getRegistration().getIdentifierType().value().equals(TYPE_BOPAV)) && CodeActionEvenement.INV.equals((Object)circulationOrienteeChargement.getCodeAction())) {
                    if (lstCirculation.size() > nombre + 1 && lstCirculation.get(nombre + 1) != null) {
                        if (!CodeActionEvenement.CRE.equals((Object)((CirculationOrienteeChargement)lstCirculation.get(nombre + 1)).getCodeAction()) || !((CirculationOrienteeChargement)lstCirculation.get(nombre + 1)).getIdentifiant().equals(((CirculationOrienteeChargement)lstCirculation.get(nombre)).getIdentifiant())) {
                            ControleV2.gestionAnomalie("J154", validation, null, null, versionSchemaReference);
                        }
                    } else {
                        ControleV2.gestionAnomalie("J154", validation, null, null, versionSchemaReference);
                    }
                }
                if (CodeActionEvenement.CRE.equals((Object)circulationOrienteeChargement.getCodeAction())) {
                    ControleV2.ControleChargement(circulationOrienteeChargement.getChargement(), validation, versionSchemaReference, dateV2depassee);
                }
                validation.setQualification(validation.getAnomalie().size() == 0);
                circulationOrienteeChargement.setValidation(validation);
                ++nombre;
            }
        }
        nombre = 0;
        if (mvtOC.getCirculationOrienteeDechargement() != null && !mvtOC.getCirculationOrienteeDechargement().isEmpty()) {
            lstCirculation = mvtOC.getCirculationOrienteeDechargement();
            for (CirculationOrienteeDechargement circulationOrienteeDechargement : lstCirculation) {
                Validation validation = circulationOrienteeDechargement.getValidation();
                if (validation == null) {
                    validation = new Validation();
                }
                identifiantOk = false;
                immatCreateur = circulationOrienteeDechargement.getCreateur().getImmatriculation();
                for (Immatriculation immatriculation : immatCreateur) {
                    if (immatriculation.getIdentifiant().equals(OVINFOS)) {
                        identifiantOk = true;
                        continue;
                    }
                    if (circulationOrienteeDechargement.getIdentifiant().length() <= immatriculation.getIdentifiant().length() || !immatriculation.getIdentifiant().equals(circulationOrienteeDechargement.getIdentifiant().substring(1, immatriculation.getIdentifiant().length() + 1))) continue;
                    identifiantOk = true;
                }
                if (!identifiantOk) {
                    ControleV2.gestionAnomalie("J011", validation, null, null, versionSchemaReference);
                }
                ControleV2.isIdentifiantOK(circulationOrienteeDechargement.getIdentifiant(), mvtOC.getIssuer().getRegistration(), circulationOrienteeDechargement.getCreateur(), validation, versionSchemaReference);
                ControleV2.ControleCreateurDestinataire(circulationOrienteeDechargement.getCreateur(), circulationOrienteeDechargement.getDestinataire(), mvtOC.getIssuer().getRegistration(), validation, versionSchemaReference);
                ControleV2.ControleIssuerCodeAction(mvtOC.getIssuer().getRegistration(), circulationOrienteeDechargement.getCodeAction().value(), validation, versionSchemaReference);
                if (CodeActionEvenement.CRE.equals((Object)circulationOrienteeDechargement.getCodeAction())) {
                    ControleV2.ControleVehicule(circulationOrienteeDechargement.getVehiculeUtilise(), validation, versionSchemaReference);
                    ControleV2.ControleOrganisationTransport(circulationOrienteeDechargement.getOrganisationTransport(), validation, versionSchemaReference);
                    ControleV2.ControleOrganisationTransportVehicule(circulationOrienteeDechargement.getOrganisationTransport(), circulationOrienteeDechargement.getVehiculeUtilise(), validation, versionSchemaReference);
                    ControleV2.ControleDateReceptionAcquisition(circulationOrienteeDechargement.getCreateur(), circulationOrienteeDechargement.getDateReceptionNotification(), validation, versionSchemaReference);
                    ControleV2.ControleModeAcquisition(circulationOrienteeDechargement.getCreateur(), circulationOrienteeDechargement.getModeAcquisition(), validation, versionSchemaReference);
                }
                if ((mvtOC.getIssuer().getRegistration().getIdentifierType().value().equals(TYPE_BELVR) || mvtOC.getIssuer().getRegistration().getIdentifierType().value().equals(TYPE_BOPAV)) && CodeActionEvenement.INV.equals((Object)circulationOrienteeDechargement.getCodeAction())) {
                    if (lstCirculation.size() > nombre + 1 && lstCirculation.get(nombre + 1) != null) {
                        if (!CodeActionEvenement.CRE.equals((Object)((CirculationOrienteeDechargement)lstCirculation.get(nombre + 1)).getCodeAction()) || !((CirculationOrienteeDechargement)lstCirculation.get(nombre + 1)).getIdentifiant().equals(((CirculationOrienteeDechargement)lstCirculation.get(nombre)).getIdentifiant())) {
                            ControleV2.gestionAnomalie("J155", validation, null, null, versionSchemaReference);
                        }
                    } else {
                        ControleV2.gestionAnomalie("J155", validation, null, null, versionSchemaReference);
                    }
                }
                if (CodeActionEvenement.CRE.equals((Object)circulationOrienteeDechargement.getCodeAction())) {
                    ControleV2.ControleDechargement(circulationOrienteeDechargement.getDechargement(), validation, versionSchemaReference, dateV2depassee);
                }
                validation.setQualification(validation.getAnomalie().size() == 0);
                circulationOrienteeDechargement.setValidation(validation);
                ++nombre;
            }
        }
    }

    private static void isIdentifiantOK(String identifiant, Registration issuer, Organisation createur, Validation validation, String versionSchemaReference) {
        String identifierType = issuer.getIdentifierType().value();
        switch (identifiant.charAt(0)) {
            case 'E': {
                if (identifierType.equals(TYPE_BNOVINFOS) || identifierType.equals(TYPE_BELVR) || identifierType.equals(TYPE_BOPAV)) break;
                ControleV2.gestionAnomalie("J006", validation, null, null, versionSchemaReference);
                break;
            }
            case 'A': {
                if (identifierType.equals(TYPE_BNOVINFOS) || identifierType.equals(TYPE_BOPAV)) break;
                ControleV2.gestionAnomalie("J007", validation, null, null, versionSchemaReference);
                break;
            }
            case 'D': {
                if (identifierType.equals(TYPE_BNOVINFOS) || identifierType.equals(TYPE_BDELG)) break;
                ControleV2.gestionAnomalie("J008", validation, null, null, versionSchemaReference);
                break;
            }
            case 'B': {
                if (identifierType.equals(TYPE_BNOVINFOS) || identifierType.equals(TYPE_BLIPG)) break;
                ControleV2.gestionAnomalie("J009", validation, null, null, versionSchemaReference);
                break;
            }
            case 'T': {
                break;
            }
            default: {
                ControleV2.gestionAnomalie("J010", validation, null, null, versionSchemaReference);
            }
        }
    }

    private static void ControleIssuerCodeAction(Registration issuer, String CodeAction, Validation validation, String versionSchemaReference) {
        if (issuer.getIdentifierType().value().equals(TYPE_BELVR) || issuer.getIdentifierType().value().equals(TYPE_BOPAV) || issuer.getIdentifierType().value().equals(TYPE_BDELG) || issuer.getIdentifierType().value().equals(TYPE_BLIPG) || issuer.getIdentifierType().value().equals(TYPE_BNOVINFOS)) {
            boolean isOk = false;
            if (!CodeAction.equals("INF")) {
                isOk = true;
            }
            if (!isOk) {
                ControleV2.gestionAnomalie("J137", validation, null, null, versionSchemaReference);
            }
        }
    }

    private static void ControleVehicule(Vehicule vehicule, Validation validation, String versionSchemaReference) {
        if (vehicule != null) {
            if (vehicule.getNumeroMineralogique().indexOf(" ") > -1) {
                ControleV2.gestionAnomalie("J140", validation, null, null, versionSchemaReference);
            }
            if (!vehicule.getNumeroMineralogique().matches("^[0-9A-Z]*$")) {
                ControleV2.gestionAnomalie("J140", validation, null, null, versionSchemaReference);
            }
        }
    }

    private static void ControleCreateurDestinataire(Organisation createur, Organisation destinataire, Registration issuer, Validation validation, String versionSchemaReference) {
        String string;
        List<String> lstCreateur;
        List<Immatriculation> immatCreateur = createur.getImmatriculation();
        if (immatCreateur.size() > 1) {
            ControleV2.gestionAnomalie("J082", validation, null, null, versionSchemaReference);
        }
        for (Immatriculation immatriculation : immatCreateur) {
            String erreur = ControleV2.isImmatriculationOk(immatriculation);
            if (erreur == null) continue;
            ControleV2.gestionAnomalie(erreur, validation, null, null, versionSchemaReference);
        }
        List<Immatriculation> immatDestinataire = destinataire.getImmatriculation();
        if (immatDestinataire.size() > 1) {
            ControleV2.gestionAnomalie("J082", validation, null, null, versionSchemaReference);
        }
        for (Immatriculation immatriculation : immatDestinataire) {
            String erreur = ControleV2.isImmatriculationOk(immatriculation);
            if (erreur == null) continue;
            ControleV2.gestionAnomalie(erreur, validation, null, null, versionSchemaReference);
        }
        if (issuer.getIdentifierType().value().equals(TYPE_BELVR) || issuer.getIdentifierType().value().equals(TYPE_BOPAV) || issuer.getIdentifierType().value().equals(TYPE_BDELG) || issuer.getIdentifierType().value().equals(TYPE_BNOVINFOS)) {
            boolean bl;
            boolean bl2 = false;
            List<Immatriculation> lstImmat = createur.getImmatriculation();
            for (Immatriculation immatriculation2 : lstImmat) {
                if (!issuer.getIdentifier().equals(immatriculation2.getIdentifiant())) continue;
                bl = true;
            }
            if (!bl) {
                ControleV2.gestionAnomalie("J135", validation, null, null, versionSchemaReference);
            }
        }
        if (issuer.getIdentifierType().value().equals(TYPE_BLIPG) && (lstCreateur = emmetteursCreateurs.get(string = issuer.getIdentifier())) != null) {
            boolean IdentifiantOk = false;
            List<Immatriculation> lstImmat = createur.getImmatriculation();
            for (Immatriculation immatriculation2 : lstImmat) {
                if (!lstCreateur.contains(immatriculation2.getIdentifiant())) continue;
                IdentifiantOk = true;
            }
            if (!IdentifiantOk) {
                ControleV2.gestionAnomalie("J135", validation, null, null, versionSchemaReference);
            }
        }
        boolean bl = false;
        List<Immatriculation> lstImmatCrea = createur.getImmatriculation();
        for (Immatriculation immatCrea : lstImmatCrea) {
            boolean bl3;
            List<Immatriculation> lstImmatDest;
            if (immatCrea.getTypeIdentifiant().value().equals(IMMA_NUM_EXPLOIT)) {
                lstImmatDest = destinataire.getImmatriculation();
                for (Immatriculation immatDest : lstImmatDest) {
                    if (!immatDest.getTypeIdentifiant().value().equals(IMMA_CODE_MOIPG) && !immatDest.getTypeIdentifiant().value().equals(TYPE_BPOVINFOS)) continue;
                    bl3 = true;
                }
            } else if (immatCrea.getTypeIdentifiant().value().equals(IMMA_NUM_AGREMENT)) {
                lstImmatDest = destinataire.getImmatriculation();
                for (Immatriculation immatDest : lstImmatDest) {
                    if (!immatDest.getTypeIdentifiant().value().equals(TYPE_BPOVINFOS)) continue;
                    bl3 = true;
                }
            } else if (immatCrea.getTypeIdentifiant().value().equals(IMMA_NUM_DELEGATAIRE)) {
                lstImmatDest = destinataire.getImmatriculation();
                for (Immatriculation immatDest : lstImmatDest) {
                    if (!immatDest.getTypeIdentifiant().value().equals(TYPE_BPOVINFOS)) continue;
                    bl3 = true;
                }
            } else if (immatCrea.getTypeIdentifiant().value().equals(IMMA_CODE_MOIPG)) {
                lstImmatDest = destinataire.getImmatriculation();
                for (Immatriculation immatDest : lstImmatDest) {
                    if (!immatDest.getTypeIdentifiant().value().equals(TYPE_BPOVINFOS)) continue;
                    bl3 = true;
                }
            } else if (immatCrea.getTypeIdentifiant().value().equals(TYPE_BPOVINFOS)) {
                lstImmatDest = destinataire.getImmatriculation();
                for (Immatriculation immatDest : lstImmatDest) {
                    if (!immatDest.getTypeIdentifiant().value().equals(TYPE_BDNI) && !immatDest.getTypeIdentifiant().value().equals(TYPE_BPOVINFOS)) continue;
                    bl3 = true;
                }
            }
            if (bl3) continue;
            ControleV2.gestionAnomalie("J136", validation, null, null, versionSchemaReference);
        }
    }

    private static String isImmatriculationOk(Immatriculation immatriculation) {
        String erreur = null;
        if (immatriculation.getTypeIdentifiant().value().equals(IMMA_NUM_EXPLOIT)) {
            if (!Utils.isIdentifiantNational(immatriculation.getIdentifiant())) {
                erreur = "J085";
            }
        } else if (immatriculation.getTypeIdentifiant().value().equals(IMMA_NUM_AGREMENT)) {
            if (!Utils.isAgrementSanitaire(immatriculation.getIdentifiant())) {
                erreur = "J084";
            }
        } else if (immatriculation.getTypeIdentifiant().value().equals(IMMA_CODE_MOIPG)) {
            if (!codesCreateur.contains(immatriculation.getIdentifiant())) {
                erreur = "J086";
            }
        } else if (immatriculation.getTypeIdentifiant().value().equals(IMMA_NUM_DELEGATAIRE)) {
            if (!immatriculation.getIdentifiant().equals(OVINFOS) && !immatriculation.getIdentifiant().matches("^FR[0-9a-zA-Z]{9}$")) {
                erreur = "J087";
            }
        } else if (immatriculation.getTypeIdentifiant().value().equals(TYPE_BDNI)) {
            if (!immatriculation.getIdentifiant().equals("031BDN")) {
                erreur = "J088";
            }
        } else if (immatriculation.getTypeIdentifiant().value().equals(TYPE_BPOVINFOS)) {
            if (!immatriculation.getIdentifiant().equals(OVINFOS)) {
                erreur = "J089";
            }
        } else {
            erreur = "J083";
        }
        return erreur;
    }

    private static void ControleCodePays(Organisation organisation, NumeroAnimal numeroAnimal, Validation validation, String versionSchemaReference) {
        if (TypeIdentifiantNumeroAnimal.V.equals((Object)numeroAnimal.getTypeIdentifiantAnimal())) {
            if (!numeroAnimal.getCodePays().matches("^[0-9A-Z]{2}$")) {
                ControleV2.gestionAnomalie("J162", validation, organisation, numeroAnimal, versionSchemaReference);
            }
        } else if (TypeIdentifiantNumeroAnimal.E.equals((Object)numeroAnimal.getTypeIdentifiantAnimal()) && !numeroAnimal.getCodePays().matches("^[0-9]{3}$")) {
            ControleV2.gestionAnomalie("J163", validation, organisation, numeroAnimal, versionSchemaReference);
        }
    }

    private static void ControleIdentifiantAnimal(Organisation organisation, NumeroAnimal numeroAnimal, Validation validation, String versionSchemaReference) {
        if (TypeIdentifiantNumeroAnimal.V.equals((Object)numeroAnimal.getTypeIdentifiantAnimal()) && "FR".equals(numeroAnimal.getCodePays())) {
            if (!numeroAnimal.getIdentifiantAnimal().matches("^[0-9]{11}$")) {
                ControleV2.gestionAnomalie("J164", validation, organisation, numeroAnimal, versionSchemaReference);
            }
        } else if (TypeIdentifiantNumeroAnimal.E.equals((Object)numeroAnimal.getTypeIdentifiantAnimal()) && !numeroAnimal.getIdentifiantAnimal().matches("^[0-9]{12}$")) {
            ControleV2.gestionAnomalie("J165", validation, organisation, numeroAnimal, versionSchemaReference);
        }
    }

    private static void ControleOrganisationTransport(OrganisationTransport organisationTransport, Validation validation, String versionSchemaReference) {
        if (organisationTransport != null) {
            boolean typeOk = false;
            List<Immatriculation> lstImmat = organisationTransport.getImmatriculation();
            for (Immatriculation immatriculation : lstImmat) {
                if (!immatriculation.getTypeIdentifiant().value().equals(TYPE_NUM_DDSV)) continue;
                typeOk = true;
                if (immatriculation.getIdentifiant().equals(INCONNU) || immatriculation.getIdentifiant().matches("^[0-9A-Z]*$")) continue;
                ControleV2.gestionAnomalie("J012", validation, null, null, versionSchemaReference);
            }
            if (!typeOk) {
                ControleV2.gestionAnomalie("J004", validation, null, null, versionSchemaReference);
            }
        }
    }

    private static void ControleOrganisationTransportVehicule(OrganisationTransport organisationTransport, Vehicule vehicule, Validation validation, String versionSchemaReference) {
        if (organisationTransport != null && vehicule == null) {
            ControleV2.gestionAnomalie("J003", validation, null, null, versionSchemaReference);
        }
        if (organisationTransport == null && vehicule != null) {
            ControleV2.gestionAnomalie("J003", validation, null, null, versionSchemaReference);
        }
    }

    private static void ControleCategorieActeurTemoinDelegation(Collecte collecte, Validation validation, String versionSchemaReference) {
        boolean controleOk = false;
        if (collecte.getChargement() != null) {
            List<Chargement> chargements = collecte.getChargement();
            for (Chargement chargement : chargements) {
                if (chargement.getCategorieActeur() == null || !chargement.getCategorieActeur().equals(CATEGORIE_ACTEUR_10) && !chargement.getCategorieActeur().equals(CATEGORIE_ACTEUR_20) || !chargement.isTemoinDelegation()) continue;
                controleOk = true;
            }
        }
        if (collecte.getDechargement() != null) {
            List<Dechargement> dechargements = collecte.getDechargement();
            for (Dechargement dechargement : dechargements) {
                if (dechargement.getCategorieActeur() == null || !dechargement.getCategorieActeur().equals(CATEGORIE_ACTEUR_10) && !dechargement.getCategorieActeur().equals(CATEGORIE_ACTEUR_20) || !dechargement.isTemoinDelegation()) continue;
                controleOk = true;
            }
        }
        if (!controleOk) {
            ControleV2.gestionAnomalie("J166", validation, null, null, versionSchemaReference);
        }
    }

    private static void ControleTypeIdentifiant(Dechargement dechargement, Validation validation, String versionSchemaReference) {
        boolean controleOk = false;
        if (dechargement.getExploitationDeDechargement() != null) {
            List<Immatriculation> lstImmat = dechargement.getExploitationDeDechargement().getImmatriculation();
            for (Immatriculation immatriculation : lstImmat) {
                if (!immatriculation.getTypeIdentifiant().value().equals(IMMA_NUM_EXPLOIT) && !immatriculation.getTypeIdentifiant().value().equals(IMMA_NUM_AGREMENT)) continue;
                controleOk = true;
            }
        }
        if (!controleOk) {
            ControleV2.gestionAnomalie("J138", validation, dechargement.getExploitationDeDechargement(), null, versionSchemaReference);
        }
    }

    private static void ControleNbImmatriculationChargement(Chargement chargement, Validation validation, String versionSchemaReference) {
        boolean controleOk = true;
        if (chargement.getExploitationChargement() != null) {
            List<Immatriculation> lstImmat = chargement.getExploitationChargement().getImmatriculation();
            if (lstImmat == null || lstImmat.size() < 1 || lstImmat.size() > 2) {
                controleOk = false;
            } else {
                int NbNumeroExploitation = 0;
                int NbNumeroSIREN = 0;
                for (Immatriculation immatriculation : lstImmat) {
                    if (immatriculation.getTypeIdentifiant().value() != null && immatriculation.getTypeIdentifiant().value().equals(IMMA_NUM_EXPLOIT)) {
                        ++NbNumeroExploitation;
                    }
                    if (immatriculation.getTypeIdentifiant().value() == null || !immatriculation.getTypeIdentifiant().value().equals(IMMA_NUM_SIREN)) continue;
                    ++NbNumeroSIREN;
                }
                if (lstImmat.size() == 1 && NbNumeroExploitation != 1) {
                    controleOk = false;
                } else if (lstImmat.size() == 2 && (NbNumeroExploitation != 1 || NbNumeroSIREN != 1)) {
                    controleOk = false;
                }
            }
            if (!controleOk) {
                ControleV2.gestionAnomalie("J022", validation, chargement.getExploitationChargement(), null, versionSchemaReference);
            }
        }
    }

    private static boolean ControleNbImmatriculationDechargementJ139(Dechargement dechargement, String versionSchemaReference) {
        boolean controleOk = true;
        if (dechargement.getExploitationDeDechargement() != null) {
            List<Immatriculation> lstImmat = dechargement.getExploitationDeDechargement().getImmatriculation();
            if (lstImmat == null || lstImmat.size() < 1 || lstImmat.size() > 2) {
                controleOk = false;
            } else {
                int NbNumeroExploitation = 0;
                int NbNumeroSIREN = 0;
                for (Immatriculation immatriculation : lstImmat) {
                    if (immatriculation.getTypeIdentifiant().value() != null && immatriculation.getTypeIdentifiant().value().equals(IMMA_NUM_EXPLOIT)) {
                        ++NbNumeroExploitation;
                    }
                    if (immatriculation.getTypeIdentifiant().value() == null || !immatriculation.getTypeIdentifiant().value().equals(IMMA_NUM_SIREN)) continue;
                    ++NbNumeroSIREN;
                }
                if (lstImmat.size() == 1 && NbNumeroExploitation != 1) {
                    controleOk = false;
                } else if (lstImmat.size() == 2 && (NbNumeroExploitation != 1 || NbNumeroSIREN != 1)) {
                    controleOk = false;
                }
            }
        }
        return controleOk;
    }

    private static boolean ControleNbImmatriculationDechargementJ027(Dechargement dechargement, String versionSchemaReference) {
        boolean controleOk = true;
        if (dechargement.getExploitationDeDechargement() != null) {
            List<Immatriculation> lstImmat = dechargement.getExploitationDeDechargement().getImmatriculation();
            if (lstImmat == null || lstImmat.size() != 2) {
                controleOk = false;
            } else {
                int NbNumeroExploitation = 0;
                int NbNumeroSIREN = 0;
                for (Immatriculation immatriculation : lstImmat) {
                    if (immatriculation.getTypeIdentifiant().value() != null && immatriculation.getTypeIdentifiant().value().equals(IMMA_NUM_EXPLOIT)) {
                        ++NbNumeroExploitation;
                    }
                    if (immatriculation.getTypeIdentifiant().value() == null || !immatriculation.getTypeIdentifiant().value().equals(IMMA_NUM_SIREN)) continue;
                    ++NbNumeroSIREN;
                }
                if (NbNumeroExploitation != 1 || NbNumeroSIREN != 1) {
                    controleOk = false;
                }
            }
        }
        return controleOk;
    }

    private static boolean ControleNbImmatriculationDechargementJ028(Dechargement dechargement, String versionSchemaReference) {
        boolean controleOk = true;
        if (dechargement.getExploitationDeDechargement() != null) {
            List<Immatriculation> lstImmat = dechargement.getExploitationDeDechargement().getImmatriculation();
            if (lstImmat == null || lstImmat.size() < 1 || lstImmat.size() > 2) {
                controleOk = false;
            } else {
                int NbNumeroAgrement = 0;
                int NbNumeroSIREN = 0;
                for (Immatriculation immatriculation : lstImmat) {
                    if (immatriculation.getTypeIdentifiant().value() != null && immatriculation.getTypeIdentifiant().value().equals(IMMA_NUM_AGREMENT)) {
                        ++NbNumeroAgrement;
                    }
                    if (immatriculation.getTypeIdentifiant().value() == null || !immatriculation.getTypeIdentifiant().value().equals(IMMA_NUM_SIREN)) continue;
                    ++NbNumeroSIREN;
                }
                if (lstImmat.size() == 1 && NbNumeroAgrement != 1) {
                    controleOk = false;
                } else if (lstImmat.size() == 2 && (NbNumeroAgrement != 1 || NbNumeroSIREN != 1)) {
                    controleOk = false;
                }
            }
        }
        return controleOk;
    }

    private static boolean ControleNbImmatriculationDechargementJ036(Dechargement dechargement, String versionSchemaReference) {
        boolean controleOk = true;
        if (dechargement.getExploitationDeDechargement() != null) {
            List<Immatriculation> lstImmat = dechargement.getExploitationDeDechargement().getImmatriculation();
            int NbNumeroExploitation = 0;
            int NbNumeroAgrement = 0;
            for (Immatriculation immatriculation : lstImmat) {
                if (immatriculation.getTypeIdentifiant().value() != null && immatriculation.getTypeIdentifiant().value().equals(IMMA_NUM_EXPLOIT)) {
                    ++NbNumeroExploitation;
                }
                if (immatriculation.getTypeIdentifiant().value() == null || !immatriculation.getTypeIdentifiant().value().equals(IMMA_NUM_AGREMENT)) continue;
                ++NbNumeroAgrement;
            }
            if (NbNumeroExploitation != 1 || NbNumeroAgrement > 0) {
                controleOk = false;
            }
        }
        return controleOk;
    }

    private static void ControleDateReceptionAcquisition(Organisation createur, XMLGregorianCalendar dateReceptionNotification, Validation validation, String versionSchemaReference) {
        List<Immatriculation> lstImmatCrea = createur.getImmatriculation();
        for (Immatriculation immatCrea : lstImmatCrea) {
            if (immatCrea.getTypeIdentifiant().value().equals(IMMA_CODE_MOIPG)) {
                if (dateReceptionNotification != null) continue;
                ControleV2.gestionAnomalie("J152", validation, null, null, versionSchemaReference);
                continue;
            }
            if (!immatCrea.getTypeIdentifiant().value().equals(TYPE_BPOVINFOS) || dateReceptionNotification != null) continue;
            ControleV2.gestionAnomalie("J153", validation, null, null, versionSchemaReference);
        }
    }

    private static void ControleModeAcquisition(Organisation createur, CodeAcquisition modeAcquisition, Validation validation, String versionSchemaReference) {
        List<Immatriculation> lstImmatCrea = createur.getImmatriculation();
        for (Immatriculation immatCrea : lstImmatCrea) {
            if (!immatCrea.getTypeIdentifiant().value().equals(IMMA_CODE_MOIPG) || modeAcquisition != null) continue;
            ControleV2.gestionAnomalie("J152", validation, null, null, versionSchemaReference);
        }
    }

    private static void ControleChargement(Chargement chargement, Validation validation, String versionSchemaReference, Boolean dateV2depassee) {
        if (chargement != null) {
            List<NumeroAnimal> lstNumCaprins;
            List<NumeroAnimal> lstNumOvins;
            if (!(chargement.getCategorieActeur().equals(CATEGORIE_ACTEUR_10) || chargement.getCategorieActeur().equals(CATEGORIE_ACTEUR_20) || chargement.getCategorieActeur().equals(CATEGORIE_ACTEUR_31) || chargement.getCategorieActeur().equals(CATEGORIE_ACTEUR_32))) {
                ControleV2.gestionAnomalie("J020", validation, chargement.getExploitationChargement(), null, versionSchemaReference);
            }
            if (chargement.getNombreCaprins() == 0 && chargement.getNombreOvins() == 0) {
                ControleV2.gestionAnomalie("J021", validation, chargement.getExploitationChargement(), null, versionSchemaReference);
            }
            List<Immatriculation> lstImma = chargement.getExploitationChargement().getImmatriculation();
            for (Immatriculation immatriculation : lstImma) {
                if (immatriculation.getTypeIdentifiant().value().equals(IMMA_NUM_EXPLOIT) && !Utils.isIdentifiantNational(immatriculation.getIdentifiant())) {
                    ControleV2.gestionAnomalie("J023", validation, chargement.getExploitationChargement(), null, versionSchemaReference);
                }
                if (!immatriculation.getTypeIdentifiant().value().equals(IMMA_NUM_SIREN) || Utils.isNumeroSiren(immatriculation.getIdentifiant()) && Utils.isLuhn(immatriculation.getIdentifiant()) && !"000000000".equals(immatriculation.getIdentifiant())) continue;
                ControleV2.gestionAnomalie("J030", validation, chargement.getExploitationChargement(), null, versionSchemaReference);
            }
            ControleV2.ControleNbImmatriculationChargement(chargement, validation, versionSchemaReference);
            if (chargement.getCategorieActeur().equals(CATEGORIE_ACTEUR_31)) {
                boolean typeExploit = false;
                boolean typeSiren = false;
                for (Immatriculation immatriculation : lstImma) {
                    if (immatriculation.getTypeIdentifiant().value().equals(IMMA_NUM_SIREN)) {
                        typeSiren = true;
                    }
                    if (!immatriculation.getTypeIdentifiant().value().equals(IMMA_NUM_EXPLOIT)) continue;
                    typeExploit = true;
                }
                if (!typeExploit || !typeSiren) {
                    ControleV2.gestionAnomalie("J029", validation, chargement.getExploitationChargement(), null, versionSchemaReference);
                }
            }
            HashMap<String, String> typeIdentifiant = new HashMap<String, String>();
            for (Immatriculation immatriculation : lstImma) {
                if (typeIdentifiant.get(immatriculation.getTypeIdentifiant().value()) == null) {
                    typeIdentifiant.put(immatriculation.getTypeIdentifiant().value(), immatriculation.getTypeIdentifiant().value());
                    continue;
                }
                ControleV2.gestionAnomalie("J143", validation, chargement.getExploitationChargement(), null, versionSchemaReference);
                break;
            }
            if (chargement.getAnimauxDerogataires() != null) {
                lstNumOvins = null;
                lstNumCaprins = null;
                if (chargement.getAnimauxDerogataires().getListeOvins() != null) {
                    lstNumOvins = chargement.getAnimauxDerogataires().getListeOvins().getNumeroAnimal();
                }
                if (chargement.getAnimauxDerogataires().getListeCaprins() != null) {
                    lstNumCaprins = chargement.getAnimauxDerogataires().getListeCaprins().getNumeroAnimal();
                }
                if (lstNumOvins != null && lstNumOvins.size() > chargement.getAnimauxDerogataires().getNombreOvinsDerogataires() || lstNumCaprins != null && lstNumCaprins.size() > chargement.getAnimauxDerogataires().getNombreCaprinsDerogataires()) {
                    ControleV2.gestionAnomalie("J144", validation, chargement.getExploitationChargement(), null, versionSchemaReference);
                }
            }
            if (chargement.getAnimauxNonDerogataires() != null) {
                lstNumOvins = null;
                lstNumCaprins = null;
                if (chargement.getAnimauxNonDerogataires().getListeOvins() != null) {
                    lstNumOvins = chargement.getAnimauxNonDerogataires().getListeOvins().getNumeroAnimal();
                }
                if (chargement.getAnimauxNonDerogataires().getListeCaprins() != null) {
                    lstNumCaprins = chargement.getAnimauxNonDerogataires().getListeCaprins().getNumeroAnimal();
                }
                if (lstNumOvins != null && lstNumOvins.size() > chargement.getAnimauxNonDerogataires().getNombreOvinsNonDerogataires() || lstNumCaprins != null && lstNumCaprins.size() > chargement.getAnimauxNonDerogataires().getNombreCaprinsNonDerogataires()) {
                    ControleV2.gestionAnomalie("J146", validation, chargement.getExploitationChargement(), null, versionSchemaReference);
                }
            }
            if (chargement.getAnimauxDerogataires() != null) {
                lstNumOvins = null;
                lstNumCaprins = null;
                if (chargement.getAnimauxDerogataires().getListeOvins() != null) {
                    lstNumOvins = chargement.getAnimauxDerogataires().getListeOvins().getNumeroAnimal();
                    for (NumeroAnimal numOvin : lstNumOvins) {
                        if (numOvin.getCodeEspece() == null || !CodeEspece.C.equals((Object)numOvin.getCodeEspece())) continue;
                        ControleV2.gestionAnomalie("J150", validation, chargement.getExploitationChargement(), numOvin, versionSchemaReference);
                    }
                }
                if (chargement.getAnimauxDerogataires().getListeCaprins() != null) {
                    lstNumCaprins = chargement.getAnimauxDerogataires().getListeCaprins().getNumeroAnimal();
                    for (NumeroAnimal numCaprin : lstNumCaprins) {
                        if (numCaprin.getCodeEspece() == null || !CodeEspece.O.equals((Object)numCaprin.getCodeEspece())) continue;
                        ControleV2.gestionAnomalie("J150", validation, chargement.getExploitationChargement(), numCaprin, versionSchemaReference);
                    }
                }
            }
            if (chargement.getAnimauxNonDerogataires() != null) {
                lstNumOvins = null;
                lstNumCaprins = null;
                if (chargement.getAnimauxNonDerogataires().getListeOvins() != null) {
                    lstNumOvins = chargement.getAnimauxNonDerogataires().getListeOvins().getNumeroAnimal();
                    for (NumeroAnimal numOvin : lstNumOvins) {
                        if (numOvin.getCodeEspece() == null || !CodeEspece.C.equals((Object)numOvin.getCodeEspece())) continue;
                        ControleV2.gestionAnomalie("J150", validation, chargement.getExploitationChargement(), numOvin, versionSchemaReference);
                    }
                }
                if (chargement.getAnimauxNonDerogataires().getListeCaprins() != null) {
                    lstNumCaprins = chargement.getAnimauxNonDerogataires().getListeCaprins().getNumeroAnimal();
                    for (NumeroAnimal numCaprin : lstNumCaprins) {
                        if (numCaprin.getCodeEspece() == null || !CodeEspece.O.equals((Object)numCaprin.getCodeEspece())) continue;
                        ControleV2.gestionAnomalie("J150", validation, chargement.getExploitationChargement(), numCaprin, versionSchemaReference);
                    }
                }
            }
            if (!(!dateV2depassee.booleanValue() || chargement.getAnimauxDerogataires() != null && chargement.getAnimauxDerogataires().getNombreOvinsDerogataires() != 0 || chargement.getAnimauxDerogataires() != null && chargement.getAnimauxDerogataires().getNombreCaprinsDerogataires() != 0 || chargement.getAnimauxNonDerogataires() != null && chargement.getAnimauxNonDerogataires().getNombreOvinsNonDerogataires() != 0 || chargement.getAnimauxNonDerogataires() != null && chargement.getAnimauxNonDerogataires().getNombreCaprinsNonDerogataires() != 0)) {
                ControleV2.gestionAnomalie("J157", validation, chargement.getExploitationChargement(), null, versionSchemaReference);
            }
            if (dateV2depassee.booleanValue()) {
                int nombreOvins = 0;
                if (chargement.getAnimauxDerogataires() != null) {
                    nombreOvins += chargement.getAnimauxDerogataires().getNombreOvinsDerogataires();
                }
                if (chargement.getAnimauxNonDerogataires() != null) {
                    nombreOvins += chargement.getAnimauxNonDerogataires().getNombreOvinsNonDerogataires();
                }
                if (chargement.getNombreOvins() != nombreOvins) {
                    ControleV2.gestionAnomalie("J159", validation, chargement.getExploitationChargement(), null, versionSchemaReference);
                }
            }
            if (dateV2depassee.booleanValue()) {
                int nombreCaprins = 0;
                if (chargement.getAnimauxDerogataires() != null) {
                    nombreCaprins += chargement.getAnimauxDerogataires().getNombreCaprinsDerogataires();
                }
                if (chargement.getAnimauxNonDerogataires() != null) {
                    nombreCaprins += chargement.getAnimauxNonDerogataires().getNombreCaprinsNonDerogataires();
                }
                if (chargement.getNombreCaprins() != nombreCaprins) {
                    ControleV2.gestionAnomalie("J160", validation, chargement.getExploitationChargement(), null, versionSchemaReference);
                }
            }
            List<NumeroAnimal> lstNum = null;
            if (chargement.getAnimauxDerogataires() != null) {
                if (chargement.getAnimauxDerogataires().getListeOvins() != null) {
                    lstNum = chargement.getAnimauxDerogataires().getListeOvins().getNumeroAnimal();
                    for (NumeroAnimal numeroAnimal : lstNum) {
                        ControleV2.ControleCodePays(chargement.getExploitationChargement(), numeroAnimal, validation, versionSchemaReference);
                        ControleV2.ControleIdentifiantAnimal(chargement.getExploitationChargement(), numeroAnimal, validation, versionSchemaReference);
                    }
                }
                if (chargement.getAnimauxDerogataires().getListeCaprins() != null) {
                    lstNum = chargement.getAnimauxDerogataires().getListeCaprins().getNumeroAnimal();
                    for (NumeroAnimal numeroAnimal : lstNum) {
                        ControleV2.ControleCodePays(chargement.getExploitationChargement(), numeroAnimal, validation, versionSchemaReference);
                        ControleV2.ControleIdentifiantAnimal(chargement.getExploitationChargement(), numeroAnimal, validation, versionSchemaReference);
                    }
                }
            }
            if (chargement.getAnimauxNonDerogataires() != null) {
                if (chargement.getAnimauxNonDerogataires().getListeOvins() != null) {
                    lstNum = chargement.getAnimauxNonDerogataires().getListeOvins().getNumeroAnimal();
                    for (NumeroAnimal numeroAnimal : lstNum) {
                        ControleV2.ControleCodePays(chargement.getExploitationChargement(), numeroAnimal, validation, versionSchemaReference);
                        ControleV2.ControleIdentifiantAnimal(chargement.getExploitationChargement(), numeroAnimal, validation, versionSchemaReference);
                    }
                }
                if (chargement.getAnimauxNonDerogataires().getListeCaprins() != null) {
                    lstNum = chargement.getAnimauxNonDerogataires().getListeCaprins().getNumeroAnimal();
                    for (NumeroAnimal numeroAnimal : lstNum) {
                        ControleV2.ControleCodePays(chargement.getExploitationChargement(), numeroAnimal, validation, versionSchemaReference);
                        ControleV2.ControleIdentifiantAnimal(chargement.getExploitationChargement(), numeroAnimal, validation, versionSchemaReference);
                    }
                }
            }
            ControleV2.ControleDate(chargement.getDate(), chargement.getHeure(), chargement.getExploitationChargement(), validation, versionSchemaReference);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void ControleDechargement(Dechargement dechargement, Validation validation, String versionSchemaReference, Boolean dateV2depassee) {
        if (dechargement != null) {
            List<NumeroAnimal> lstNumCaprins;
            if (!(dechargement.getCategorieActeur().equals(CATEGORIE_ACTEUR_10) || dechargement.getCategorieActeur().equals(CATEGORIE_ACTEUR_20) || dechargement.getCategorieActeur().equals(CATEGORIE_ACTEUR_31) || dechargement.getCategorieActeur().equals(CATEGORIE_ACTEUR_32) || dechargement.getCategorieActeur().equals(CATEGORIE_ACTEUR_40))) {
                ControleV2.gestionAnomalie("J024", validation, dechargement.getExploitationDeDechargement(), null, versionSchemaReference);
            }
            if (dechargement.getNombreCaprins() == 0 && dechargement.getNombreOvins() == 0 && dechargement.getNombreMorts() == 0) {
                ControleV2.gestionAnomalie("J025", validation, dechargement.getExploitationDeDechargement(), null, versionSchemaReference);
            }
            List<Immatriculation> lstImma = dechargement.getExploitationDeDechargement().getImmatriculation();
            for (Immatriculation immatriculation : lstImma) {
                if (immatriculation.getTypeIdentifiant().value().equals(IMMA_NUM_SIREN) && (!Utils.isNumeroSiren(immatriculation.getIdentifiant()) || !Utils.isLuhn(immatriculation.getIdentifiant()) || "000000000".equals(immatriculation.getIdentifiant()))) {
                    ControleV2.gestionAnomalie("J030", validation, dechargement.getExploitationDeDechargement(), null, versionSchemaReference);
                }
                if (immatriculation.getTypeIdentifiant().value().equals(IMMA_NUM_EXPLOIT) && !Utils.isIdentifiantNational(immatriculation.getIdentifiant())) {
                    ControleV2.gestionAnomalie("J026", validation, dechargement.getExploitationDeDechargement(), null, versionSchemaReference);
                }
                if (!immatriculation.getTypeIdentifiant().value().equals(IMMA_NUM_AGREMENT) || Utils.isAgrementSanitaire(immatriculation.getIdentifiant())) continue;
                ControleV2.gestionAnomalie("J031", validation, dechargement.getExploitationDeDechargement(), null, versionSchemaReference);
            }
            if (dechargement.getCategorieActeur().equals(CATEGORIE_ACTEUR_31) && !ControleV2.ControleNbImmatriculationDechargementJ027(dechargement, versionSchemaReference)) {
                ControleV2.gestionAnomalie("J027", validation, dechargement.getExploitationDeDechargement(), null, versionSchemaReference);
            }
            if (dechargement.getCategorieActeur().equals(CATEGORIE_ACTEUR_40) && !ControleV2.ControleNbImmatriculationDechargementJ028(dechargement, versionSchemaReference)) {
                ControleV2.gestionAnomalie("J028", validation, dechargement.getExploitationDeDechargement(), null, versionSchemaReference);
            }
            if (dechargement.getCategorieActeur().equals(CATEGORIE_ACTEUR_10) || dechargement.getCategorieActeur().equals(CATEGORIE_ACTEUR_20) || dechargement.getCategorieActeur().equals(CATEGORIE_ACTEUR_32)) {
                if (!ControleV2.ControleNbImmatriculationDechargementJ036(dechargement, versionSchemaReference)) {
                    ControleV2.gestionAnomalie("J036", validation, dechargement.getExploitationDeDechargement(), null, versionSchemaReference);
                }
                for (Immatriculation immatriculation : lstImma) {
                    if (!immatriculation.getTypeIdentifiant().value().equals(IMMA_NUM_EXPLOIT) || Utils.isIdentifiantNational(immatriculation.getIdentifiant())) continue;
                    ControleV2.gestionAnomalie("J026", validation, dechargement.getExploitationDeDechargement(), null, versionSchemaReference);
                }
            }
            HashMap<String, String> typeIdentifiant = new HashMap<String, String>();
            for (Immatriculation immatriculation : lstImma) {
                if (typeIdentifiant.get(immatriculation.getTypeIdentifiant().value()) == null) {
                    typeIdentifiant.put(immatriculation.getTypeIdentifiant().value(), immatriculation.getTypeIdentifiant().value());
                    continue;
                }
                ControleV2.gestionAnomalie("J143", validation, dechargement.getExploitationDeDechargement(), null, versionSchemaReference);
                break;
            }
            if (dechargement.getAnimauxDerogataires() != null) {
                void var6_12;
                Object var6_10 = null;
                lstNumCaprins = null;
                Iterator<NumeroAnimal> lstNumMorts = null;
                if (dechargement.getAnimauxDerogataires().getListeOvins() != null) {
                    List<NumeroAnimal> list = dechargement.getAnimauxDerogataires().getListeOvins().getNumeroAnimal();
                }
                if (dechargement.getAnimauxDerogataires().getListeCaprins() != null) {
                    lstNumCaprins = dechargement.getAnimauxDerogataires().getListeCaprins().getNumeroAnimal();
                }
                if (dechargement.getListeMorts() != null) {
                    lstNumMorts = dechargement.getListeMorts().getNumeroAnimal();
                }
                if (var6_12 != null && var6_12.size() > dechargement.getAnimauxDerogataires().getNombreOvinsDerogataires() || lstNumCaprins != null && lstNumCaprins.size() > dechargement.getAnimauxDerogataires().getNombreCaprinsDerogataires() || lstNumMorts != null && lstNumMorts.size() > dechargement.getNombreMorts()) {
                    ControleV2.gestionAnomalie("J147", validation, dechargement.getExploitationDeDechargement(), null, versionSchemaReference);
                }
            }
            if (dechargement.getAnimauxNonDerogataires() != null) {
                void var6_16;
                Object var6_14 = null;
                lstNumCaprins = null;
                if (dechargement.getAnimauxNonDerogataires().getListeOvins() != null) {
                    List<NumeroAnimal> list = dechargement.getAnimauxNonDerogataires().getListeOvins().getNumeroAnimal();
                }
                if (dechargement.getAnimauxNonDerogataires().getListeCaprins() != null) {
                    lstNumCaprins = dechargement.getAnimauxNonDerogataires().getListeCaprins().getNumeroAnimal();
                }
                if (var6_16 != null && var6_16.size() > dechargement.getAnimauxNonDerogataires().getNombreOvinsNonDerogataires() || lstNumCaprins != null && lstNumCaprins.size() > dechargement.getAnimauxNonDerogataires().getNombreCaprinsNonDerogataires()) {
                    ControleV2.gestionAnomalie("J148", validation, dechargement.getExploitationDeDechargement(), null, versionSchemaReference);
                }
            }
            if (dechargement.getAnimauxDerogataires() != null) {
                Object var6_18 = null;
                lstNumCaprins = null;
                if (dechargement.getAnimauxDerogataires().getListeOvins() != null) {
                    List<NumeroAnimal> list = dechargement.getAnimauxDerogataires().getListeOvins().getNumeroAnimal();
                    for (NumeroAnimal numOvin : list) {
                        if (numOvin.getCodeEspece() == null || !CodeEspece.C.equals((Object)numOvin.getCodeEspece())) continue;
                        ControleV2.gestionAnomalie("J150", validation, dechargement.getExploitationDeDechargement(), numOvin, versionSchemaReference);
                    }
                }
                if (dechargement.getAnimauxDerogataires().getListeCaprins() != null) {
                    lstNumCaprins = dechargement.getAnimauxDerogataires().getListeCaprins().getNumeroAnimal();
                    for (NumeroAnimal numCaprin : lstNumCaprins) {
                        if (numCaprin.getCodeEspece() == null || !CodeEspece.O.equals((Object)numCaprin.getCodeEspece())) continue;
                        ControleV2.gestionAnomalie("J150", validation, dechargement.getExploitationDeDechargement(), numCaprin, versionSchemaReference);
                    }
                }
            }
            if (dechargement.getAnimauxNonDerogataires() != null) {
                Object var6_22 = null;
                lstNumCaprins = null;
                if (dechargement.getAnimauxNonDerogataires().getListeOvins() != null) {
                    List<NumeroAnimal> list = dechargement.getAnimauxNonDerogataires().getListeOvins().getNumeroAnimal();
                    for (NumeroAnimal numOvin : list) {
                        if (numOvin.getCodeEspece() == null || !CodeEspece.C.equals((Object)numOvin.getCodeEspece())) continue;
                        ControleV2.gestionAnomalie("J150", validation, dechargement.getExploitationDeDechargement(), numOvin, versionSchemaReference);
                    }
                }
                if (dechargement.getAnimauxNonDerogataires().getListeCaprins() != null) {
                    lstNumCaprins = dechargement.getAnimauxNonDerogataires().getListeCaprins().getNumeroAnimal();
                    for (NumeroAnimal numCaprin : lstNumCaprins) {
                        if (numCaprin.getCodeEspece() == null || !CodeEspece.O.equals((Object)numCaprin.getCodeEspece())) continue;
                        ControleV2.gestionAnomalie("J150", validation, dechargement.getExploitationDeDechargement(), numCaprin, versionSchemaReference);
                    }
                }
            }
            if (dechargement.getListeMorts() != null) {
                List<NumeroAnimal> list = dechargement.getListeMorts().getNumeroAnimal();
                for (NumeroAnimal num : list) {
                    if (num.getCodeEspece() != null && !"".equals((Object)num.getCodeEspece())) continue;
                    ControleV2.gestionAnomalie("J167", validation, dechargement.getExploitationDeDechargement(), num, versionSchemaReference);
                }
            }
            if (!(!dateV2depassee.booleanValue() || dechargement.getAnimauxDerogataires() != null && dechargement.getAnimauxDerogataires().getNombreOvinsDerogataires() != 0 || dechargement.getAnimauxDerogataires() != null && dechargement.getAnimauxDerogataires().getNombreCaprinsDerogataires() != 0 || dechargement.getAnimauxNonDerogataires() != null && dechargement.getAnimauxNonDerogataires().getNombreOvinsNonDerogataires() != 0 || dechargement.getAnimauxNonDerogataires() != null && dechargement.getAnimauxNonDerogataires().getNombreCaprinsNonDerogataires() != 0 || dechargement.getNombreMorts() != 0)) {
                ControleV2.gestionAnomalie("J158", validation, dechargement.getExploitationDeDechargement(), null, versionSchemaReference);
            }
            if (dateV2depassee.booleanValue()) {
                void var6_30;
                int n;
                int n2 = 0;
                if (dechargement.getAnimauxDerogataires() != null) {
                    n = n2 + dechargement.getAnimauxDerogataires().getNombreOvinsDerogataires();
                }
                if (dechargement.getAnimauxNonDerogataires() != null) {
                    var6_30 = n + dechargement.getAnimauxNonDerogataires().getNombreOvinsNonDerogataires();
                }
                if (dechargement.getNombreOvins() != var6_30) {
                    ControleV2.gestionAnomalie("J159", validation, dechargement.getExploitationDeDechargement(), null, versionSchemaReference);
                }
            }
            if (dateV2depassee.booleanValue()) {
                void var6_33;
                int n;
                int n3 = 0;
                if (dechargement.getAnimauxDerogataires() != null) {
                    n = n3 + dechargement.getAnimauxDerogataires().getNombreCaprinsDerogataires();
                }
                if (dechargement.getAnimauxNonDerogataires() != null) {
                    var6_33 = n + dechargement.getAnimauxNonDerogataires().getNombreCaprinsNonDerogataires();
                }
                if (dechargement.getNombreCaprins() != var6_33) {
                    ControleV2.gestionAnomalie("J160", validation, dechargement.getExploitationDeDechargement(), null, versionSchemaReference);
                }
            }
            Object var6_34 = null;
            if (dechargement.getAnimauxDerogataires() != null) {
                if (dechargement.getAnimauxDerogataires().getListeOvins() != null) {
                    List<NumeroAnimal> list = dechargement.getAnimauxDerogataires().getListeOvins().getNumeroAnimal();
                    for (NumeroAnimal num : list) {
                        ControleV2.ControleCodePays(dechargement.getExploitationDeDechargement(), num, validation, versionSchemaReference);
                        ControleV2.ControleIdentifiantAnimal(dechargement.getExploitationDeDechargement(), num, validation, versionSchemaReference);
                    }
                }
                if (dechargement.getAnimauxDerogataires().getListeCaprins() != null) {
                    List<NumeroAnimal> list = dechargement.getAnimauxDerogataires().getListeCaprins().getNumeroAnimal();
                    for (NumeroAnimal num : list) {
                        ControleV2.ControleCodePays(dechargement.getExploitationDeDechargement(), num, validation, versionSchemaReference);
                        ControleV2.ControleIdentifiantAnimal(dechargement.getExploitationDeDechargement(), num, validation, versionSchemaReference);
                    }
                }
            }
            if (dechargement.getAnimauxNonDerogataires() != null) {
                if (dechargement.getAnimauxNonDerogataires().getListeOvins() != null) {
                    List<NumeroAnimal> list = dechargement.getAnimauxNonDerogataires().getListeOvins().getNumeroAnimal();
                    for (NumeroAnimal num : list) {
                        ControleV2.ControleCodePays(dechargement.getExploitationDeDechargement(), num, validation, versionSchemaReference);
                        ControleV2.ControleIdentifiantAnimal(dechargement.getExploitationDeDechargement(), num, validation, versionSchemaReference);
                    }
                }
                if (dechargement.getAnimauxNonDerogataires().getListeCaprins() != null) {
                    List<NumeroAnimal> list = dechargement.getAnimauxNonDerogataires().getListeCaprins().getNumeroAnimal();
                    for (NumeroAnimal num : list) {
                        ControleV2.ControleCodePays(dechargement.getExploitationDeDechargement(), num, validation, versionSchemaReference);
                        ControleV2.ControleIdentifiantAnimal(dechargement.getExploitationDeDechargement(), num, validation, versionSchemaReference);
                    }
                }
            }
            ControleV2.ControleDate(dechargement.getDate(), dechargement.getHeure(), dechargement.getExploitationDeDechargement(), validation, versionSchemaReference);
        }
    }

    private static void ControlerCirculationOrienteeChargement(CirculationOrienteeChargement circulation, String versionSchemaReference) {
        Validation validation = circulation.getValidation();
        if (validation == null) {
            validation = new Validation();
        }
        List<Immatriculation> lstImmaCreateur = circulation.getCreateur().getImmatriculation();
        for (Immatriculation immatCrea : lstImmaCreateur) {
            if (!immatCrea.getTypeIdentifiant().value().equals(IMMA_NUM_DELEGATAIRE)) continue;
            ControleV2.gestionAnomalie("J063", validation, null, null, versionSchemaReference);
        }
        Chargement chargement = circulation.getChargement();
        if (chargement.isTemoinDelegation()) {
            ControleV2.gestionAnomalie("J040", validation, chargement.getExploitationChargement(), null, versionSchemaReference);
        }
        if ((chargement.getCategorieActeur().equals(CATEGORIE_ACTEUR_10) || chargement.getCategorieActeur().equals(CATEGORIE_ACTEUR_20)) && (circulation.getVehiculeUtilise() == null || circulation.getOrganisationTransport() == null)) {
            ControleV2.gestionAnomalie("J044", validation, chargement.getExploitationChargement(), null, versionSchemaReference);
        }
        List<Immatriculation> lstImma = chargement.getExploitationChargement().getImmatriculation();
        for (Immatriculation immatriculation : lstImma) {
            if (!immatriculation.getTypeIdentifiant().value().equals(IMMA_NUM_EXPLOIT)) continue;
            Organisation createur = circulation.getCreateur();
            List<Immatriculation> lstImmaCrea = createur.getImmatriculation();
            for (Immatriculation immatCrea : lstImmaCrea) {
                if (immatCrea.getTypeIdentifiant().value().equals(IMMA_CODE_MOIPG)) {
                    String identifiant = immatCrea.getIdentifiant();
                    if (identifiant.length() == 6 && identifiant.endsWith("IPG")) {
                        if (identifiant.charAt(0) == '0') {
                            if (!(identifiant.subSequence(1, 3).equals("2A") || identifiant.subSequence(1, 3).equals("2B") || identifiant.subSequence(1, 3).equals(immatriculation.getIdentifiant().substring(2, 4)))) {
                                ControleV2.gestionAnomalie("J015", validation, chargement.getExploitationChargement(), null, versionSchemaReference);
                            }
                            if (!identifiant.subSequence(1, 3).equals("2A") && !identifiant.subSequence(1, 3).equals("2B") || immatriculation.getIdentifiant().substring(2, 4).equals(CATEGORIE_ACTEUR_20)) continue;
                            ControleV2.gestionAnomalie("J015", validation, chargement.getExploitationChargement(), null, versionSchemaReference);
                            continue;
                        }
                        if (identifiant.charAt(0) != '0' && !identifiant.subSequence(0, 3).equals("974")) {
                            if (identifiant.substring(0, 3).equals(immatriculation.getIdentifiant().substring(2, 5))) continue;
                            ControleV2.gestionAnomalie("J015", validation, chargement.getExploitationChargement(), null, versionSchemaReference);
                            continue;
                        }
                        if (identifiant.charAt(0) == '0' || !identifiant.subSequence(0, 3).equals("974") || immatriculation.getIdentifiant().substring(2, 4).equals("98")) continue;
                        ControleV2.gestionAnomalie("J015", validation, chargement.getExploitationChargement(), null, versionSchemaReference);
                        continue;
                    }
                    ControleV2.gestionAnomalie("J015", validation, chargement.getExploitationChargement(), null, versionSchemaReference);
                    continue;
                }
                if (immatCrea.getIdentifiant().equals(immatriculation.getIdentifiant())) continue;
                ControleV2.gestionAnomalie("J015", validation, chargement.getExploitationChargement(), null, versionSchemaReference);
            }
        }
        Destination destination = circulation.getDestination();
        List<Immatriculation> lstImmaDest = destination.getOrganisationDetaillee().getImmatriculation();
        if (lstImmaDest.size() > 2) {
            ControleV2.gestionAnomalie("J058", validation, chargement.getExploitationChargement(), null, versionSchemaReference);
        } else {
            boolean testNumeroSiren = false;
            boolean numeroSirenOk = false;
            boolean numeroExploitationOk = false;
            boolean numeroAgrementOk = false;
            if (lstImmaDest.size() == 2) {
                testNumeroSiren = true;
            }
            for (Immatriculation immatDest : lstImmaDest) {
                if (immatDest.getTypeIdentifiant().value().equals(IMMA_NUM_EXPLOIT)) {
                    numeroExploitationOk = true;
                    if (!immatDest.getIdentifiant().equals(NUM_INEXISTANT) && !Utils.isIdentifiantNational(immatDest.getIdentifiant())) {
                        ControleV2.gestionAnomalie("J032", validation, chargement.getExploitationChargement(), null, versionSchemaReference);
                    }
                    if (immatDest.getIdentifiant().equals(NUM_INEXISTANT)) {
                        if (destination.getOrganisationDetaillee().getAdresse() != null && destination.getOrganisationDetaillee().getPersonne() != null) {
                            Adresse adresse = destination.getOrganisationDetaillee().getAdresse();
                            Personne personne = destination.getOrganisationDetaillee().getPersonne();
                            if (adresse.getCodePostal().equals("") || adresse.getLocalite() == null || personne.getNomDeFamille() == null || personne.getPrenom() == null) {
                                ControleV2.gestionAnomalie("J035", validation, chargement.getExploitationChargement(), null, versionSchemaReference);
                            }
                        } else {
                            ControleV2.gestionAnomalie("J035", validation, chargement.getExploitationChargement(), null, versionSchemaReference);
                        }
                    }
                } else if (immatDest.getTypeIdentifiant().value().equals(IMMA_NUM_SIREN)) {
                    numeroSirenOk = true;
                    if (!Utils.isNumeroSiren(immatDest.getIdentifiant()) || !Utils.isLuhn(immatDest.getIdentifiant()) || "000000000".equals(immatDest.getIdentifiant())) {
                        ControleV2.gestionAnomalie("J030", validation, chargement.getExploitationChargement(), null, versionSchemaReference);
                    }
                } else if (immatDest.getTypeIdentifiant().value().equals(IMMA_NUM_AGREMENT)) {
                    numeroAgrementOk = true;
                    if (!Utils.isAgrementSanitaire(immatDest.getIdentifiant())) {
                        ControleV2.gestionAnomalie("J031", validation, chargement.getExploitationChargement(), null, versionSchemaReference);
                    }
                } else if (immatDest.getTypeIdentifiant().value().equals(IMMA_CERTIF_UE) || immatDest.getTypeIdentifiant().value().equals(IMMA_CERTIF_PAYS_TIERS)) {
                    if (!immatDest.getIdentifiant().equals(ETRANGER)) {
                        ControleV2.gestionAnomalie("J037", validation, chargement.getExploitationChargement(), null, versionSchemaReference);
                    }
                    if (circulation.getDestination().getOrganisationDetaillee().getNumeroCertificat() == null || circulation.getDestination().getOrganisationDetaillee().getNumeroCertificat().equals("")) {
                        ControleV2.gestionAnomalie("J038", validation, chargement.getExploitationChargement(), null, versionSchemaReference);
                    } else if (Utils.isValeurUniquementZero(circulation.getDestination().getOrganisationDetaillee().getNumeroCertificat())) {
                        ControleV2.gestionAnomalie("J038", validation, chargement.getExploitationChargement(), null, versionSchemaReference);
                    }
                    if (circulation.getVehiculeUtilise() == null || circulation.getOrganisationTransport() == null) {
                        ControleV2.gestionAnomalie("J043", validation, chargement.getExploitationChargement(), null, versionSchemaReference);
                    }
                } else {
                    ControleV2.gestionAnomalie("J039", validation, chargement.getExploitationChargement(), null, versionSchemaReference);
                }
                if (immatDest.getIdentifiant().equals(ETRANGER) && !immatDest.getTypeIdentifiant().value().equals(IMMA_CERTIF_UE) && !immatDest.getTypeIdentifiant().value().equals(IMMA_CERTIF_PAYS_TIERS)) {
                    ControleV2.gestionAnomalie("J037", validation, chargement.getExploitationChargement(), null, versionSchemaReference);
                }
                if ((immatDest.getIdentifiant().equals(ETRANGER) || immatDest.getIdentifiant().equals(NUM_INEXISTANT)) && destination.getCategorieActeur() != null && !"".equals(destination.getCategorieActeur())) {
                    ControleV2.gestionAnomalie("J161", validation, chargement.getExploitationChargement(), null, versionSchemaReference);
                }
                if (immatDest.getIdentifiant().equals(NUM_INEXISTANT) || immatDest.getTypeIdentifiant().value().equals(IMMA_CERTIF_UE) || immatDest.getTypeIdentifiant().value().equals(IMMA_CERTIF_PAYS_TIERS) || destination.getCategorieActeur() != null && !"".equals(destination.getCategorieActeur())) continue;
                ControleV2.gestionAnomalie("J039", validation, chargement.getExploitationChargement(), null, versionSchemaReference);
            }
            if (testNumeroSiren && !numeroSirenOk) {
                ControleV2.gestionAnomalie("J059", validation, chargement.getExploitationChargement(), null, versionSchemaReference);
            }
            if (!(!numeroSirenOk || numeroExploitationOk || numeroAgrementOk || circulation.getVehiculeUtilise() != null && circulation.getOrganisationTransport() != null)) {
                ControleV2.gestionAnomalie("J042", validation, chargement.getExploitationChargement(), null, versionSchemaReference);
            }
            if (destination.getCategorieActeur() != null && (destination.getCategorieActeur().equals(CATEGORIE_ACTEUR_10) || destination.getCategorieActeur().equals(CATEGORIE_ACTEUR_20) || destination.getCategorieActeur().equals(CATEGORIE_ACTEUR_31) || destination.getCategorieActeur().equals(CATEGORIE_ACTEUR_32)) && !numeroExploitationOk) {
                ControleV2.gestionAnomalie("J050", validation, chargement.getExploitationChargement(), null, versionSchemaReference);
            }
            if (destination.getCategorieActeur() != null && destination.getCategorieActeur().equals(CATEGORIE_ACTEUR_40) && !numeroAgrementOk) {
                ControleV2.gestionAnomalie("J051", validation, chargement.getExploitationChargement(), null, versionSchemaReference);
            }
            if (destination.getCategorieActeur() != null && destination.getCategorieActeur().equals(CATEGORIE_ACTEUR_34) && !numeroSirenOk) {
                ControleV2.gestionAnomalie("J049", validation, chargement.getExploitationChargement(), null, versionSchemaReference);
            }
        }
        validation.setQualification(validation.getAnomalie().size() == 0);
        circulation.setValidation(validation);
    }

    private static void ControlerCirculationOrienteeDechargement(CirculationOrienteeDechargement circulation, String versionSchemaReference) {
        Validation validation = circulation.getValidation();
        if (validation == null) {
            validation = new Validation();
        }
        List<Immatriculation> lstImmaCreateur = circulation.getCreateur().getImmatriculation();
        for (Immatriculation immatCrea : lstImmaCreateur) {
            if (!immatCrea.getTypeIdentifiant().value().equals(IMMA_NUM_DELEGATAIRE)) continue;
            ControleV2.gestionAnomalie("J064", validation, null, null, versionSchemaReference);
        }
        Dechargement dechargement = circulation.getDechargement();
        if (dechargement.isTemoinDelegation()) {
            ControleV2.gestionAnomalie("J041", validation, dechargement.getExploitationDeDechargement(), null, versionSchemaReference);
        }
        if ((dechargement.getCategorieActeur().equals(CATEGORIE_ACTEUR_10) || dechargement.getCategorieActeur().equals(CATEGORIE_ACTEUR_20)) && (circulation.getVehiculeUtilise() == null || circulation.getOrganisationTransport() == null)) {
            ControleV2.gestionAnomalie("J046", validation, dechargement.getExploitationDeDechargement(), null, versionSchemaReference);
        }
        List<Immatriculation> lstImma = dechargement.getExploitationDeDechargement().getImmatriculation();
        for (Immatriculation immatriculation : lstImma) {
            if (!immatriculation.getTypeIdentifiant().value().equals(IMMA_NUM_EXPLOIT) && !immatriculation.getTypeIdentifiant().value().equals(IMMA_NUM_AGREMENT)) continue;
            Organisation createur = circulation.getCreateur();
            List<Immatriculation> lstImmaCrea = createur.getImmatriculation();
            for (Immatriculation immatCrea : lstImmaCrea) {
                if (immatCrea.getTypeIdentifiant().value().equals(IMMA_CODE_MOIPG)) {
                    String identifiant = immatCrea.getIdentifiant();
                    if (identifiant.length() == 6 && identifiant.endsWith("IPG")) {
                        if (identifiant.charAt(0) == '0') {
                            if ((immatriculation.getTypeIdentifiant().value().equals(IMMA_NUM_AGREMENT) || !identifiant.subSequence(1, 3).equals("2A") && !identifiant.subSequence(1, 3).equals("2B")) && !identifiant.subSequence(1, 3).equals(immatriculation.getIdentifiant().substring(2, 4))) {
                                ControleV2.gestionAnomalie("J016", validation, dechargement.getExploitationDeDechargement(), null, versionSchemaReference);
                            }
                            if (!immatriculation.getTypeIdentifiant().value().equals(IMMA_NUM_EXPLOIT) || !identifiant.subSequence(1, 3).equals("2A") && !identifiant.subSequence(1, 3).equals("2B") || immatriculation.getIdentifiant().substring(2, 4).equals(CATEGORIE_ACTEUR_20)) continue;
                            ControleV2.gestionAnomalie("J016", validation, dechargement.getExploitationDeDechargement(), null, versionSchemaReference);
                            continue;
                        }
                        if (identifiant.charAt(0) != '0' && !identifiant.subSequence(0, 3).equals("974")) {
                            if (identifiant.substring(0, 3).equals(immatriculation.getIdentifiant().substring(2, 5))) continue;
                            ControleV2.gestionAnomalie("J016", validation, dechargement.getExploitationDeDechargement(), null, versionSchemaReference);
                            continue;
                        }
                        if (identifiant.charAt(0) == '0' || !identifiant.subSequence(0, 3).equals("974") || immatriculation.getIdentifiant().substring(2, 4).equals("98")) continue;
                        ControleV2.gestionAnomalie("J016", validation, dechargement.getExploitationDeDechargement(), null, versionSchemaReference);
                        continue;
                    }
                    ControleV2.gestionAnomalie("J016", validation, dechargement.getExploitationDeDechargement(), null, versionSchemaReference);
                    continue;
                }
                if (immatCrea.getIdentifiant().equals(immatriculation.getIdentifiant()) || !immatriculation.getTypeIdentifiant().value().equals(IMMA_NUM_AGREMENT) && (!immatriculation.getTypeIdentifiant().value().equals(IMMA_NUM_EXPLOIT) || immatCrea.getTypeIdentifiant().value().equals(TYPE_BPOVINFOS))) continue;
                ControleV2.gestionAnomalie("J016", validation, dechargement.getExploitationDeDechargement(), null, versionSchemaReference);
            }
        }
        Provenance provenance = circulation.getProvenance();
        List<Immatriculation> lstImmaDest = provenance.getOrganisationDetaillee().getImmatriculation();
        if (lstImmaDest.size() > 2) {
            ControleV2.gestionAnomalie("J058", validation, dechargement.getExploitationDeDechargement(), null, versionSchemaReference);
        } else {
            boolean testNumeroSiren = false;
            boolean numeroSirenOk = false;
            boolean numeroExploitationOk = false;
            boolean numeroInexistantOk = false;
            if (lstImmaDest.size() == 2) {
                testNumeroSiren = true;
            }
            for (Immatriculation immatDest : lstImmaDest) {
                if (immatDest.getTypeIdentifiant().value().equals(IMMA_NUM_EXPLOIT)) {
                    numeroExploitationOk = true;
                    if (!immatDest.getIdentifiant().equals(NUM_INEXISTANT) && !Utils.isIdentifiantNational(immatDest.getIdentifiant())) {
                        ControleV2.gestionAnomalie("J033", validation, dechargement.getExploitationDeDechargement(), null, versionSchemaReference);
                    }
                    if (immatDest.getIdentifiant().equals(NUM_INEXISTANT)) {
                        numeroInexistantOk = true;
                    }
                } else if (immatDest.getTypeIdentifiant().value().equals(IMMA_NUM_SIREN)) {
                    numeroSirenOk = true;
                    if (!Utils.isNumeroSiren(immatDest.getIdentifiant()) || !Utils.isLuhn(immatDest.getIdentifiant()) || "000000000".equals(immatDest.getIdentifiant())) {
                        ControleV2.gestionAnomalie("J030", validation, dechargement.getExploitationDeDechargement(), null, versionSchemaReference);
                    }
                } else if (immatDest.getTypeIdentifiant().value().equals(IMMA_CERTIF_UE) || immatDest.getTypeIdentifiant().value().equals(IMMA_CERTIF_PAYS_TIERS)) {
                    if (!immatDest.getIdentifiant().equals(ETRANGER)) {
                        ControleV2.gestionAnomalie("J037", validation, dechargement.getExploitationDeDechargement(), null, versionSchemaReference);
                    }
                    if (circulation.getProvenance().getOrganisationDetaillee().getNumeroCertificat() == null || circulation.getProvenance().getOrganisationDetaillee().getNumeroCertificat().equals("")) {
                        ControleV2.gestionAnomalie("J038", validation, dechargement.getExploitationDeDechargement(), null, versionSchemaReference);
                    } else if (Utils.isValeurUniquementZero(circulation.getProvenance().getOrganisationDetaillee().getNumeroCertificat())) {
                        ControleV2.gestionAnomalie("J038", validation, dechargement.getExploitationDeDechargement(), null, versionSchemaReference);
                    }
                    if (circulation.getVehiculeUtilise() == null || circulation.getOrganisationTransport() == null) {
                        ControleV2.gestionAnomalie("J054", validation, dechargement.getExploitationDeDechargement(), null, versionSchemaReference);
                    }
                } else {
                    ControleV2.gestionAnomalie("J048", validation, dechargement.getExploitationDeDechargement(), null, versionSchemaReference);
                }
                if (immatDest.getIdentifiant().equals(ETRANGER) && !immatDest.getTypeIdentifiant().value().equals(IMMA_CERTIF_UE) && !immatDest.getTypeIdentifiant().value().equals(IMMA_CERTIF_PAYS_TIERS)) {
                    ControleV2.gestionAnomalie("J037", validation, dechargement.getExploitationDeDechargement(), null, versionSchemaReference);
                }
                if (immatDest.getTypeIdentifiant().value().equals(IMMA_NUM_EXPLOIT) && immatDest.getIdentifiant().equals(NUM_INEXISTANT)) {
                    if (provenance.getOrganisationDetaillee().getAdresse() != null) {
                        if (provenance.getOrganisationDetaillee().getAdresse().getCodePostal() == null || "".equals(provenance.getOrganisationDetaillee().getAdresse().getCodePostal())) {
                            ControleV2.gestionAnomalie("J142", validation, dechargement.getExploitationDeDechargement(), null, versionSchemaReference);
                        }
                        if (provenance.getOrganisationDetaillee().getAdresse().getLocalite() == null || "".equals(provenance.getOrganisationDetaillee().getAdresse().getLocalite())) {
                            ControleV2.gestionAnomalie("J142", validation, dechargement.getExploitationDeDechargement(), null, versionSchemaReference);
                        }
                    } else {
                        ControleV2.gestionAnomalie("J142", validation, dechargement.getExploitationDeDechargement(), null, versionSchemaReference);
                    }
                    if (provenance.getOrganisationDetaillee().getPersonne() != null) {
                        if (provenance.getOrganisationDetaillee().getPersonne().getNomDeFamille() == null || "".equals(provenance.getOrganisationDetaillee().getPersonne().getNomDeFamille())) {
                            ControleV2.gestionAnomalie("J142", validation, dechargement.getExploitationDeDechargement(), null, versionSchemaReference);
                        }
                        if (provenance.getOrganisationDetaillee().getPersonne().getPrenom() == null || "".equals(provenance.getOrganisationDetaillee().getPersonne().getPrenom())) {
                            ControleV2.gestionAnomalie("J142", validation, dechargement.getExploitationDeDechargement(), null, versionSchemaReference);
                        }
                    } else {
                        ControleV2.gestionAnomalie("J142", validation, dechargement.getExploitationDeDechargement(), null, versionSchemaReference);
                    }
                }
                if ((immatDest.getIdentifiant().equals(ETRANGER) || immatDest.getIdentifiant().equals(NUM_INEXISTANT)) && provenance.getCategorieActeur() != null && !"".equals(provenance.getCategorieActeur())) {
                    ControleV2.gestionAnomalie("J161", validation, dechargement.getExploitationDeDechargement(), null, versionSchemaReference);
                }
                if (immatDest.getIdentifiant().equals(NUM_INEXISTANT) || immatDest.getTypeIdentifiant().value().equals(IMMA_CERTIF_UE) || immatDest.getTypeIdentifiant().value().equals(IMMA_CERTIF_PAYS_TIERS) || provenance.getCategorieActeur() != null && !"".equals(provenance.getCategorieActeur())) continue;
                ControleV2.gestionAnomalie("J048", validation, dechargement.getExploitationDeDechargement(), null, versionSchemaReference);
            }
            if (testNumeroSiren && !numeroSirenOk) {
                ControleV2.gestionAnomalie("J059", validation, dechargement.getExploitationDeDechargement(), null, versionSchemaReference);
            }
            if (numeroSirenOk && !numeroExploitationOk && (circulation.getVehiculeUtilise() == null || circulation.getOrganisationTransport() == null)) {
                ControleV2.gestionAnomalie("J053", validation, dechargement.getExploitationDeDechargement(), null, versionSchemaReference);
            }
            if (provenance.getCategorieActeur() != null && (provenance.getCategorieActeur().equals(CATEGORIE_ACTEUR_10) || provenance.getCategorieActeur().equals(CATEGORIE_ACTEUR_20) || provenance.getCategorieActeur().equals(CATEGORIE_ACTEUR_31) || provenance.getCategorieActeur().equals(CATEGORIE_ACTEUR_32)) && !numeroExploitationOk) {
                ControleV2.gestionAnomalie("J055", validation, dechargement.getExploitationDeDechargement(), null, versionSchemaReference);
            }
            if (provenance.getCategorieActeur() != null && provenance.getCategorieActeur().equals(CATEGORIE_ACTEUR_34) && !numeroSirenOk) {
                ControleV2.gestionAnomalie("J056", validation, dechargement.getExploitationDeDechargement(), null, versionSchemaReference);
            }
            if (!dechargement.getCategorieActeur().equals(CATEGORIE_ACTEUR_40) && numeroExploitationOk && numeroInexistantOk) {
                ControleV2.gestionAnomalie("J057", validation, dechargement.getExploitationDeDechargement(), null, versionSchemaReference);
            }
        }
        if (!(provenance.getCategorieActeur() == null || provenance.getCategorieActeur().equals(CATEGORIE_ACTEUR_10) || provenance.getCategorieActeur().equals(CATEGORIE_ACTEUR_20) || provenance.getCategorieActeur().equals(CATEGORIE_ACTEUR_31) || provenance.getCategorieActeur().equals(CATEGORIE_ACTEUR_32) || provenance.getCategorieActeur().equals(CATEGORIE_ACTEUR_34))) {
            ControleV2.gestionAnomalie("J034", validation, dechargement.getExploitationDeDechargement(), null, versionSchemaReference);
        }
        validation.setQualification(validation.getAnomalie().size() == 0);
        circulation.setValidation(validation);
    }

    private static void gestionAnomalie(String codeErreur, Validation validation, Organisation organisation, NumeroAnimal numeroAnimal, String versionSchemaReference) {
        String numExploitation = "";
        String numAnimal = "";
        Anomalie anomalieAModifier = null;
        if (organisation != null) {
            List<Immatriculation> listImmat = organisation.getImmatriculation();
            for (Immatriculation immatriculation : listImmat) {
                if (!immatriculation.getTypeIdentifiant().value().equals(IMMA_NUM_EXPLOIT)) continue;
                numExploitation = immatriculation.getIdentifiant();
            }
        }
        if (numeroAnimal != null) {
            numAnimal = numeroAnimal.getIdentifiantAnimal();
        }
        if (validation.getAnomalie() != null && !validation.getAnomalie().isEmpty()) {
            List<Anomalie> lstAnomalie = validation.getAnomalie();
            for (Anomalie anomalie : lstAnomalie) {
                if (!anomalie.getCodeAnomalie().equals((Object)OCAnomalyCodeType.fromValue(codeErreur))) continue;
                if (anomalie.getDetailAnomalie() != null) {
                    if (anomalie.getDetailAnomalie().getExploitation() != null) {
                        if (!anomalie.getDetailAnomalie().getExploitation().getImmatriculation().get(0).getIdentifiant().equals(numExploitation)) continue;
                        anomalieAModifier = anomalie;
                        break;
                    }
                    if (numExploitation != null && !"".equals(numExploitation)) continue;
                    anomalieAModifier = anomalie;
                    break;
                }
                if (numExploitation != null && !"".equals(numExploitation)) continue;
                anomalieAModifier = anomalie;
                break;
            }
        }
        if (anomalieAModifier == null) {
            Anomalie anomalie = new Anomalie();
            anomalie.setCodeAnomalie(OCAnomalyCodeType.fromValue(codeErreur));
            anomalie.setTypeAnomalie("1");
            anomalie.setLibelleAnomalie(MsgErr.getMsgErr(codeErreur, versionSchemaReference));
            if (numExploitation != null && !"".equals(numExploitation) || numAnimal != null && !"".equals(numAnimal)) {
                DetailAnomalie detailAnomalie = new DetailAnomalie();
                if (numExploitation != null && !"".equals(numExploitation)) {
                    Organisation exploitation = new Organisation();
                    Immatriculation immatriculation = new Immatriculation();
                    immatriculation.setIdentifiant(numExploitation);
                    immatriculation.setTypeIdentifiant(OCRegistrationIdentifiantTypeType.fromValue(IMMA_NUM_EXPLOIT));
                    exploitation.getImmatriculation().add(immatriculation);
                    detailAnomalie.setExploitation(exploitation);
                }
                if (numAnimal != null && !"".equals(numAnimal)) {
                    detailAnomalie.getNumeroAnimal().add(numeroAnimal);
                }
                anomalie.setDetailAnomalie(detailAnomalie);
            }
            validation.getAnomalie().add(anomalie);
            validation.setQualification(false);
        } else if (numAnimal != null && !"".equals(numAnimal)) {
            anomalieAModifier.getDetailAnomalie().getNumeroAnimal().add(numeroAnimal);
        }
    }

    private static void ControleDate(XMLGregorianCalendar date, XMLGregorianCalendar heure, Organisation organisation, Validation validation, String versionSchemaReference) {
        XMLGregorianCalendar dateHeure = null;
        if (date != null) {
            dateHeure = (XMLGregorianCalendar)date.clone();
            if (heure != null) {
                dateHeure.setTimezone(heure.getTimezone());
                dateHeure.setTime(heure.getHour(), heure.getMinute(), heure.getSecond());
            }
            if (dateCreation.compare(dateHeure) == -1) {
                ControleV2.gestionAnomalie("J052", validation, organisation, null, versionSchemaReference);
            }
        }
    }

    static {
        codesEmetteur = new ArrayList<String>();
        codesCreateur = new ArrayList<String>();
        emmetteursCreateurs = new HashMap();
        HashSet<String> tmpEm = new HashSet<String>();
        HashSet<String> tmpCr = new HashSet<String>();
        ResourceBundle bundle = null;
        ResourceBundle bundleFinHabilitation = null;
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
        Date dateFinHabilitation = null;
        Date dateTraitement = null;
        try {
            String valeur = null;
            String[] codes = null;
            dateTraitement = sdf.parse(sdf.format(new Date()));
            bundle = ResourceBundle.getBundle(FILE_NAME);
            bundleFinHabilitation = ResourceBundle.getBundle(FILE_NAME_FIN_HABILTATION);
            Enumeration<String> keys = bundle.getKeys();
            while (keys.hasMoreElements()) {
                String key = keys.nextElement();
                if (key == null) continue;
                dateFinHabilitation = null;
                try {
                    dateFinHabilitation = sdf.parse(bundleFinHabilitation.getString(key));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (dateFinHabilitation != null && dateTraitement.compareTo(dateFinHabilitation) > 0) continue;
                ArrayList<String> lstTmp = new ArrayList<String>();
                tmpEm.add(key);
                valeur = bundle.getString(key);
                for (String code : codes = valeur.split(",")) {
                    tmpCr.add(code);
                    lstTmp.add(code);
                }
                emmetteursCreateurs.put(key, lstTmp);
            }
            codesEmetteur.addAll(tmpEm);
            codesCreateur.addAll(tmpCr);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

