/*
 * Decompiled with CFR 0.152.
 */
package com.teamlog.simoc.xml;

public class Utils {
    public static boolean isCodeDepartement(String code) {
        boolean resultat = false;
        try {
            if (code.length() == 2) {
                if (code.equals("2A") || code.equals("2B")) {
                    resultat = true;
                } else {
                    int num = Integer.parseInt(code);
                    if (num >= 1 && num <= 95 || num == 97 || num == 98) {
                        resultat = true;
                    }
                }
            } else if (code.length() == 3) {
                if (code.charAt(0) == '0') {
                    int num = Integer.parseInt(code);
                    if (num >= 1 && num <= 95 || num == 97 || num == 98) {
                        resultat = true;
                    }
                } else if (code.charAt(0) == '9') {
                    int num = Integer.parseInt(code);
                    if (num >= 971 && num <= 974) {
                        resultat = true;
                    }
                } else if ((code = code.substring(0, 2)).equals("2A") || code.equals("2B")) {
                    resultat = true;
                } else {
                    int num = Integer.parseInt(code);
                    if (num >= 1 && num <= 95 || num == 97 || num == 98) {
                        resultat = true;
                    }
                }
            }
        }
        catch (NumberFormatException e) {
            resultat = false;
        }
        return resultat;
    }

    public static boolean isIdentifiantNational(String identifiant) {
        if (identifiant.matches("^FR[0-9]{8}$")) {
            String code = identifiant.substring(2, 4);
            return Utils.isCodeDepartement(code);
        }
        return false;
    }

    public static boolean isAgrementSanitaire(String agrement) {
        if (agrement.matches("^FR[0-9a-zA-Z]{8}$")) {
            String code = agrement.substring(2, 5);
            if (!agrement.substring(2, 5).startsWith("97")) {
                code = agrement.substring(2, 4);
            }
            return Utils.isCodeDepartement(code);
        }
        return false;
    }

    public static boolean isIdentifiantDetenteur(String identifiant) {
        if (identifiant.matches("^FR[0-9AB]{3}[0-9A-Z]{1,9}$")) {
            String code = identifiant.substring(2, 5);
            return Utils.isCodeDepartement(code);
        }
        return false;
    }

    public static boolean isNumeroSiren(String numero) {
        return numero.matches("^[0-9]{9}$");
    }

    public static boolean isLuhn(String numero) {
        int sum = 0;
        boolean alternate = false;
        for (int i = numero.length() - 1; i >= 0; --i) {
            int n = Integer.parseInt(numero.substring(i, i + 1));
            if (alternate && (n *= 2) > 9) {
                n = n % 10 + 1;
            }
            sum += n;
            alternate = !alternate;
        }
        return sum % 10 == 0;
    }

    public static boolean isValeurUniquementZero(String valeur) {
        return valeur.matches("^[0]*$");
    }
}

