/*
 * Decompiled with CFR 0.152.
 */
package com;

import com.teamlog.simoc.xml.Controle;
import com.teamlog.simoc.xml.MsgErr;
import com.teamlog.simoc.xml.XmlUtils;
import com.teamlog.simoc.xmlObject.NotificationMouvementLotOvinCaprin;
import fr.cmre.simoc.xml.V2.ControleV2;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.ResourceBundle;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConfoSimoc {
    private static Log logger = LogFactory.getLog(ConfoSimoc.class);
    static final String REP_TRAVAIL_DEFAUT = "validation";
    static final String REP_XSD_V111 = "xsd";
    static final String REP_XSD_V2 = "xsd_V2";
    static final String FICHIER_XSD_V111 = "XMLNotificationOvinCaprinV111.XSD";
    static final String FICHIER_XSD_V2 = "XMLNotificationOvinCaprinV2.XSD";
    private static File repTravail = null;
    private static File fichierXsd = null;
    private static File fichierXsdV111 = null;
    private static File fichierXsdV2 = null;
    private static String versionSchemaReference = null;
    private static Boolean dateV2depassee = null;
    private static final String FILE_NAME = "confosimoc";
    private static ResourceBundle bundle = null;

    static {
        try {
            bundle = ResourceBundle.getBundle(FILE_NAME);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Erreur lors de la r\u00e9cup\u00e9ration dans le fichier de config confosimoc");
        }
    }

    /*
     * Unable to fully structure code
     */
    public static void main(String[] args) {
        if (ConfoSimoc.Initialisation(args)) {
            jc = null;
            try {
                jc = JAXBContext.newInstance((String)"com.teamlog.simoc.xmlObject");
            }
            catch (JAXBException e) {
                ConfoSimoc.logger.error(e.getMessage());
                System.exit(1);
            }
            jcV2 = null;
            try {
                jcV2 = JAXBContext.newInstance((String)"fr.cmre.simoc.xmlObject.V2");
            }
            catch (JAXBException e) {
                ConfoSimoc.logger.error(e.getMessage());
                System.exit(1);
            }
            var7_6 = fichiers = ConfoSimoc.repTravail.listFiles();
            var6_7 = fichiers.length;
            var5_8 = 0;
            while (var5_8 < var6_7) {
                block30: {
                    fichier = var7_6[var5_8];
                    mvtOC = null;
                    mvtOCV2 = null;
                    erreurs = new ArrayList<String>();
                    anomalies = new ArrayList<String>();
                    fichierValide = false;
                    try {
                        ConfoSimoc.logger.debug("Traitement du fichier : " + fichier.getName());
                        ConfoSimoc.logger.debug("[1] Recherche du sch\u00e9ma de r\u00e9f\u00e9rence du fichier xml");
                        ConfoSimoc.versionSchemaReference = XmlUtils.rechercherSchemaReference((String)fichier.getPath(), erreurs);
                        ConfoSimoc.fichierXsd = ConfoSimoc.versionSchemaReference != null && "V111".equals(ConfoSimoc.versionSchemaReference) != false && ConfoSimoc.dateV2depassee == false ? ConfoSimoc.fichierXsdV111 : (ConfoSimoc.versionSchemaReference != null && "V2".equals(ConfoSimoc.versionSchemaReference) != false ? ConfoSimoc.fichierXsdV2 : null);
                        if (ConfoSimoc.fichierXsd != null) {
                            if (XmlUtils.formatNomFichierValide((String)fichier.getName(), (String)".xml")) {
                                ConfoSimoc.logger.debug("[2] Contr\u00f4le des codes ASCII");
                                if (XmlUtils.ControlerCodeASCII((String)fichier.getPath(), erreurs, (String)ConfoSimoc.versionSchemaReference)) {
                                    ConfoSimoc.logger.debug("[3] Conversion du fichier xml");
                                    if ("V111".equals(ConfoSimoc.versionSchemaReference)) {
                                        mvtOC = XmlUtils.lireFichierXML((JAXBContext)jc, (String)fichier.getPath(), (String)ConfoSimoc.fichierXsd.getAbsolutePath(), erreurs, (String)ConfoSimoc.versionSchemaReference);
                                    } else if ("V2".equals(ConfoSimoc.versionSchemaReference)) {
                                        mvtOCV2 = XmlUtils.lireFichierXMLV2((JAXBContext)jcV2, (String)fichier.getPath(), (String)ConfoSimoc.fichierXsd.getAbsolutePath(), erreurs, (String)ConfoSimoc.versionSchemaReference);
                                    }
                                    ConfoSimoc.logger.debug("[4] Contr\u00f4le de coh\u00e9rence des donn\u00e9es");
                                    if (mvtOC != null && Controle.VerifierCoherence((NotificationMouvementLotOvinCaprin)mvtOC, erreurs, (String)fichier.getName(), (String)ConfoSimoc.versionSchemaReference)) {
                                        fichierValide = true;
                                    }
                                    if (mvtOCV2 != null && ControleV2.VerifierCoherence((fr.cmre.simoc.xmlObject.V2.NotificationMouvementLotOvinCaprin)mvtOCV2, erreurs, (String)fichier.getName(), (String)ConfoSimoc.versionSchemaReference, (Boolean)ConfoSimoc.dateV2depassee)) {
                                        fichierValide = true;
                                    }
                                }
                            } else {
                                ConfoSimoc.logger.debug("Rejet du fichier " + fichier.getName() + " : erreur de nommage");
                                erreurs.add("erreur de nommage");
                                fichierValide = false;
                            }
                        } else {
                            erreurs.add(MsgErr.getMsgErr((String)"JG920", (String)ConfoSimoc.versionSchemaReference));
                            fichierValide = false;
                        }
                        break block30;
                    }
                    catch (Exception e) {
                        ConfoSimoc.logger.error("Erreur inattendue sur le fichier " + fichier.getName());
                        ConfoSimoc.logger.error(e.toString());
                        sb = new StringBuffer();
                        var19_28 = st = e.getStackTrace();
                        var18_23 = st.length;
                        var17_20 = 0;
                        ** while (var17_20 < var18_23)
                    }
lbl-1000:
                    // 1 sources

                    {
                        stackTraceElement = var19_28[var17_20];
                        sb.append(stackTraceElement.toString()).append(System.getProperty("line.separator"));
                        ++var17_20;
                        continue;
                    }
lbl69:
                    // 1 sources

                    ConfoSimoc.logger.error(sb.toString());
                    erreurs.add("Erreur inattendue");
                }
                if (!fichierValide) {
                    nomSansExtension = fichier.getName().substring(0, fichier.getName().length() - 4);
                    if (erreurs.size() == 0) {
                        nomFichierRep = new File(ConfoSimoc.repTravail.getAbsolutePath(), String.valueOf(nomSansExtension) + "_REP.xml");
                        ConfoSimoc.logger.debug("Cr\u00e9ation du fichier de r\u00e9ponse " + nomFichierRep.getPath());
                        if (mvtOC != null) {
                            mvtOC.setIdentification(nomFichierRep.getName());
                            mvtOC.setDocumentOrigine(fichier.getName());
                            date = new Date();
                            gCalendar = new GregorianCalendar();
                            gCalendar.setTime(date);
                            try {
                                dtf = DatatypeFactory.newInstance();
                                xmlCalendar = dtf.newXMLGregorianCalendar(gCalendar);
                                mvtOC.setCreation(xmlCalendar);
                            }
                            catch (DatatypeConfigurationException e) {
                                ConfoSimoc.logger.debug(e.getMessage());
                            }
                            ConfoSimoc.logger.debug("Re\u00e9criture du fichier xml " + nomFichierRep.getName());
                            XmlUtils.ecrireFichierXML((JAXBContext)jc, (NotificationMouvementLotOvinCaprin)mvtOC, (String)nomFichierRep.getPath());
                        }
                        if (mvtOCV2 != null) {
                            mvtOCV2.setIdentification(nomFichierRep.getName());
                            mvtOCV2.setDocumentOrigine(fichier.getName());
                            date = new Date();
                            gCalendar = new GregorianCalendar();
                            gCalendar.setTime(date);
                            try {
                                dtf = DatatypeFactory.newInstance();
                                xmlCalendar = dtf.newXMLGregorianCalendar(gCalendar);
                                mvtOCV2.setCreation(xmlCalendar);
                            }
                            catch (DatatypeConfigurationException e) {
                                ConfoSimoc.logger.debug(e.getMessage());
                            }
                            ConfoSimoc.logger.debug("Re\u00e9criture du fichier xml " + nomFichierRep.getName());
                            XmlUtils.ecrireFichierXMLV2((JAXBContext)jc, (fr.cmre.simoc.xmlObject.V2.NotificationMouvementLotOvinCaprin)mvtOCV2, (String)nomFichierRep.getPath());
                        }
                    } else {
                        nomFichierLog = new File(ConfoSimoc.repTravail.getAbsolutePath(), String.valueOf(nomSansExtension) + "_ERR.txt");
                        ConfoSimoc.logger.debug("Ecriture du fichier log " + nomFichierLog.getPath());
                        XmlUtils.EcrireFichierLog((String)nomFichierLog.getPath(), erreurs);
                    }
                }
                if (ConfoSimoc.versionSchemaReference != null && "V111".equals(ConfoSimoc.versionSchemaReference) && !ConfoSimoc.dateV2depassee.booleanValue()) {
                    nomSansExtension = fichier.getName().substring(0, fichier.getName().length() - 4);
                    nomFichierLog = new File(ConfoSimoc.repTravail.getAbsolutePath(), String.valueOf(nomSansExtension) + "_ANO.txt");
                    ConfoSimoc.logger.debug("Ecriture du fichier log " + nomFichierLog.getPath());
                    anomalies.add(ConfoSimoc.bundle.getString("A001"));
                    XmlUtils.EcrireFichierLog((String)nomFichierLog.getPath(), anomalies);
                }
                ++var5_8;
            }
        } else {
            System.exit(1);
        }
        System.exit(0);
    }

    private static boolean Initialisation(String[] args) {
        boolean resultat = true;
        if (args.length > 1) {
            logger.error("Nombre de param\u00e8tres de l'application invalide.");
            resultat = false;
        } else if (args.length == 1) {
            File arg = new File(args[0]);
            if (!arg.isDirectory() && !arg.isFile()) {
                logger.error("Le param\u00e8tre [" + args[0] + "] n'est ni un r\u00e9pertoire ni un fichier valide.");
                resultat = false;
            } else if (arg.isDirectory()) {
                repTravail = new File(args[0]);
            }
        } else {
            repTravail = new File(REP_TRAVAIL_DEFAUT);
        }
        fichierXsdV111 = new File(REP_XSD_V111, FICHIER_XSD_V111);
        if (!fichierXsdV111.exists()) {
            logger.error("Le r\u00e9pertoire " + fichierXsdV111.getAbsolutePath() + " n'existe pas.");
            resultat = false;
        }
        if (!(fichierXsdV2 = new File(REP_XSD_V2, FICHIER_XSD_V2)).exists()) {
            logger.error("Le r\u00e9pertoire " + fichierXsdV2.getAbsolutePath() + " n'existe pas.");
            resultat = false;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
        Date dateTraitement = null;
        Date dateV2 = null;
        try {
            dateTraitement = sdf.parse(sdf.format(new Date()));
            dateV2 = sdf.parse(bundle.getString("DATE_V2"));
            dateV2depassee = dateTraitement.compareTo(dateV2) >= 0 ? Boolean.valueOf(true) : Boolean.valueOf(false);
        }
        catch (Exception e1) {
            logger.error("Erreur lors de la recherche si sch\u00e9ma de r\u00e9f\u00e9rence V111 autoris\u00e9");
            resultat = false;
        }
        return resultat;
    }
}

