/*
 * Decompiled with CFR 0.152.
 */
package com.teamlog.simoc.xml;

import com.teamlog.simoc.xml.MsgErr;
import com.teamlog.simoc.xmlObject.NotificationMouvementLotOvinCaprin;
import com.teamlog.simoc.xmlObject.ObjectFactory;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.ValidationEventLocator;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlUtils {
    static List<String> erreursXsd = null;

    public static NotificationMouvementLotOvinCaprin lireFichierXML(JAXBContext jaxbCtx, String nomFichier, String fichierXSD, List<String> erreurs, String versionSchemaReference) {
        NotificationMouvementLotOvinCaprin po = null;
        try {
            erreursXsd = new ArrayList<String>();
            Unmarshaller u = jaxbCtx.createUnmarshaller();
            if (fichierXSD != null && !fichierXSD.equals("")) {
                SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                try {
                    Schema schema = sf.newSchema(new File(fichierXSD));
                    u.setSchema(schema);
                    u.setEventHandler(new ValidationEventHandler(){

                        public boolean handleEvent(ValidationEvent ve) {
                            if (ve.getSeverity() != 0) {
                                ValidationEventLocator vel = ve.getLocator();
                                erreursXsd.add("Line:Col[" + vel.getLineNumber() + ":" + vel.getColumnNumber() + "]:" + ve.getMessage());
                            }
                            return true;
                        }
                    });
                }
                catch (SAXException se) {
                    System.out.println("Unable to validate due to following error.");
                    se.printStackTrace();
                }
            }
            JAXBElement poElement = (JAXBElement)u.unmarshal((InputStream)new FileInputStream(nomFichier));
            po = (NotificationMouvementLotOvinCaprin)poElement.getValue();
            if (erreursXsd != null && !erreursXsd.isEmpty()) {
                erreurs.add(MsgErr.getMsgErr("JGXXX", versionSchemaReference));
                erreurs.addAll(erreursXsd);
                po = null;
            }
            if (po != null && !po.getIdentification().equals(new File(nomFichier).getName())) {
                erreurs.add(MsgErr.getMsgErr("JG929", versionSchemaReference));
                po = null;
            }
        }
        catch (JAXBException e) {
            if (e.getLinkedException() instanceof SAXParseException) {
                erreurs.add(MsgErr.getMsgErr("JG909", versionSchemaReference));
            }
        }
        catch (FileNotFoundException e) {
            System.err.println(e.getMessage());
        }
        return po;
    }

    public static fr.cmre.simoc.xmlObject.V2.NotificationMouvementLotOvinCaprin lireFichierXMLV2(JAXBContext jaxbCtx, String nomFichier, String fichierXSD, List<String> erreurs, String versionSchemaReference) {
        fr.cmre.simoc.xmlObject.V2.NotificationMouvementLotOvinCaprin po = null;
        try {
            erreursXsd = new ArrayList<String>();
            Unmarshaller u = jaxbCtx.createUnmarshaller();
            if (fichierXSD != null && !fichierXSD.equals("")) {
                SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                try {
                    Schema schema = sf.newSchema(new File(fichierXSD));
                    u.setSchema(schema);
                    u.setEventHandler(new ValidationEventHandler(){

                        public boolean handleEvent(ValidationEvent ve) {
                            if (ve.getSeverity() != 0) {
                                ValidationEventLocator vel = ve.getLocator();
                                erreursXsd.add("Line:Col[" + vel.getLineNumber() + ":" + vel.getColumnNumber() + "]:" + ve.getMessage());
                            }
                            return true;
                        }
                    });
                }
                catch (SAXException se) {
                    System.out.println("Unable to validate due to following error.");
                    se.printStackTrace();
                }
            }
            JAXBElement poElement = (JAXBElement)u.unmarshal((InputStream)new FileInputStream(nomFichier));
            po = (fr.cmre.simoc.xmlObject.V2.NotificationMouvementLotOvinCaprin)poElement.getValue();
            if (erreursXsd != null && !erreursXsd.isEmpty()) {
                erreurs.add(MsgErr.getMsgErr("JGXXX", versionSchemaReference));
                erreurs.addAll(erreursXsd);
                po = null;
            }
            if (po != null && !po.getIdentification().equals(new File(nomFichier).getName())) {
                erreurs.add(MsgErr.getMsgErr("JG929", versionSchemaReference));
                po = null;
            }
        }
        catch (JAXBException e) {
            if (e.getLinkedException() instanceof SAXParseException) {
                erreurs.add(MsgErr.getMsgErr("JG909", versionSchemaReference));
            } else {
                erreurs.add(MsgErr.getMsgErr("JG920", versionSchemaReference));
            }
        }
        catch (FileNotFoundException e) {
            System.err.println(e.getMessage());
        }
        return po;
    }

    public static void ecrireFichierXML(JAXBContext jaxbCtx, NotificationMouvementLotOvinCaprin mvtOC, String nomFichier) {
        try {
            String schemaLocation = "";
            schemaLocation = schemaLocation + "urn:fr:agri:elevage:codelist:FarmCategory:1 FarmCategory.XSD ";
            schemaLocation = schemaLocation + "urn:fr:agri:elevage:codelist:OCAnomalyCode:1 OCAnomalyCode.XSD ";
            schemaLocation = schemaLocation + "urn:fr:agri:elevage:codelist:OCRegistrationIdentifiantType:1 OCRegistrationIdentifiantType.XSD ";
            schemaLocation = schemaLocation + "urn:fr:agri:elevage:codelist:NumberPlateCountryCode:1 NumberPlateCountryCode.XSD ";
            schemaLocation = schemaLocation + "http://www.inst-elevage.asso.fr/XML/Schema  XMLNotificationOvinCaprinV111.XSD";
            JAXBElement<NotificationMouvementLotOvinCaprin> poElement = new ObjectFactory().createNotificationMouvementOvinCaprin(mvtOC);
            Marshaller m = jaxbCtx.createMarshaller();
            m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            m.setProperty("jaxb.schemaLocation", (Object)schemaLocation);
            m.setProperty("jaxb.encoding", (Object)"ISO-8859-1");
            FileOutputStream fo = new FileOutputStream(nomFichier);
            m.marshal(poElement, (OutputStream)fo);
            fo.flush();
            fo.close();
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void ecrireFichierXMLV2(JAXBContext jaxbCtx, fr.cmre.simoc.xmlObject.V2.NotificationMouvementLotOvinCaprin mvtOC, String nomFichier) {
        try {
            String schemaLocation = "";
            schemaLocation = schemaLocation + "urn:fr:agri:elevage:codelist:FarmCategory:1 FarmCategory.XSD ";
            schemaLocation = schemaLocation + "urn:fr:agri:elevage:codelist:OCAnomalyCode:1 OCAnomalyCode.XSD ";
            schemaLocation = schemaLocation + "urn:fr:agri:elevage:codelist:OCRegistrationIdentifiantType:1 OCRegistrationIdentifiantType.XSD ";
            schemaLocation = schemaLocation + "urn:fr:agri:elevage:codelist:NumberPlateCountryCode:1 NumberPlateCountryCode.XSD ";
            schemaLocation = schemaLocation + "urn:fr:agri:elevage:codelist:CodePaysAnimal:1 CodePaysAnimal.XSD ";
            schemaLocation = schemaLocation + "urn:fr:agri:elevage:codelist:CauseEntreeOC:1 CauseEntreeOC.XSD ";
            schemaLocation = schemaLocation + "urn:fr:agri:elevage:codelist:CauseSortieOC:1 CauseSortieOC.XSD ";
            schemaLocation = schemaLocation + "http://www.idele.fr/XML/Schema XMLNotificationOvinCaprinV2.XSD";
            JAXBElement<fr.cmre.simoc.xmlObject.V2.NotificationMouvementLotOvinCaprin> poElement = new ObjectFactory().createNotificationMouvementOvinCaprinV2(mvtOC);
            Marshaller m = jaxbCtx.createMarshaller();
            m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            m.setProperty("jaxb.schemaLocation", (Object)schemaLocation);
            m.setProperty("jaxb.encoding", (Object)"ISO-8859-1");
            FileOutputStream fo = new FileOutputStream(nomFichier);
            m.marshal(poElement, (OutputStream)fo);
            fo.flush();
            fo.close();
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static boolean ControlerCodeASCII(String nomFichier, List<String> erreurs, String versionSchemaReference) {
        boolean resultat = false;
        int pos = 0;
        String balisePrecedente = "";
        int posFinPrecedente = 0;
        File f = new File(nomFichier);
        if (f.exists() && f.isFile() && f.canRead() && f.length() > 0L) {
            try {
                int c = 0;
                boolean lineFeedOk = true;
                FileReader fr = new FileReader(f);
                for (long nbCar = 0L; (c = fr.read()) != -1 && nbCar <= f.length(); ++nbCar) {
                    if (c != 13) continue;
                    lineFeedOk = false;
                }
                fr.close();
                if (!lineFeedOk) {
                    erreurs.add(MsgErr.getMsgErr("JG971", versionSchemaReference));
                }
                if (c != -1) {
                    erreurs.add(MsgErr.getMsgErr("JG972", versionSchemaReference));
                } else {
                    boolean horsPlage = false;
                    boolean uniquementEspace = false;
                    BufferedReader br = new BufferedReader(new FileReader(f));
                    String ligne = null;
                    while ((ligne = br.readLine()) != null) {
                        pos = 0;
                        balisePrecedente = "";
                        posFinPrecedente = 0;
                        int nombreCaracteresDebutBalise = ligne.split("<").length - 1;
                        int nombreCaracteresFinBalise = ligne.split(">").length - 1;
                        if (nombreCaracteresFinBalise <= 0) continue;
                        for (int i = 0; i < nombreCaracteresDebutBalise; ++i) {
                            int posFin;
                            int posDebut = ligne.indexOf("<", pos == 0 ? pos : pos + 1);
                            String balise = ligne.substring(posDebut, posFin = ligne.indexOf(">", posDebut) + 1);
                            if (balise.replace("/", "").equals(balisePrecedente)) {
                                String valeurBalise = ligne.substring(posFinPrecedente, posDebut);
                                if (valeurBalise.matches("^[ ]*$")) {
                                    uniquementEspace = true;
                                }
                                for (c = 0; c < valeurBalise.length(); ++c) {
                                    if (valeurBalise.charAt(c) >= ' ' && valeurBalise.charAt(c) <= '~') continue;
                                    horsPlage = true;
                                    break;
                                }
                            }
                            pos = posFin - 1;
                            balisePrecedente = balise;
                            posFinPrecedente = posFin;
                        }
                    }
                    br.close();
                    if (horsPlage) {
                        erreurs.add(MsgErr.getMsgErr("JG906", versionSchemaReference));
                    }
                    if ("V2".equals(versionSchemaReference) && uniquementEspace) {
                        erreurs.add(MsgErr.getMsgErr("JG141", versionSchemaReference));
                    }
                    if (!(!lineFeedOk || horsPlage || "V2".equals(versionSchemaReference) && uniquementEspace)) {
                        resultat = true;
                    }
                }
            }
            catch (FileNotFoundException e) {
                System.err.println(e.getMessage());
            }
            catch (IOException e) {
                System.err.println(e.getMessage());
            }
        } else {
            erreurs.add("Le fichier " + nomFichier + " est invalide. V\u00e9rifier qu'il existe bien et qu'il ne soit pas vide.");
        }
        return resultat;
    }

    public static String rechercherSchemaReference(String nomFichier, List<String> erreurs) {
        String schemaReferenceFichier = "";
        File f = new File(nomFichier);
        if (f.exists() && f.isFile() && f.canRead() && f.length() > 0L) {
            try {
                BufferedReader br = new BufferedReader(new FileReader(f));
                String ligne = null;
                while ((ligne = br.readLine()) != null) {
                    if (ligne.contains("XMLNotificationOvinCaprinV111.XSD")) {
                        schemaReferenceFichier = "V111";
                        break;
                    }
                    if (ligne.contains("http://www.idele.fr/XML/Schema XMLNotificationOvinCaprinV2.XSD")) {
                        schemaReferenceFichier = "V2";
                        break;
                    }
                    schemaReferenceFichier = "";
                }
                br.close();
            }
            catch (FileNotFoundException e) {
                System.err.println(e.getMessage());
            }
            catch (IOException e) {
                System.err.println(e.getMessage());
            }
        } else {
            erreurs.add("Le fichier " + nomFichier + " est invalide. V\u00e9rifier qu'il existe bien et qu'il ne soit pas vide.");
        }
        return schemaReferenceFichier;
    }

    public static void EcrireFichierLog(String nomFichier, List<String> erreurs) {
        try {
            BufferedWriter f = new BufferedWriter(new FileWriter(nomFichier));
            for (String string : erreurs) {
                f.write(string);
                f.newLine();
            }
            f.flush();
            f.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static File UnZipXml(String nomFichier, String repDest, List<String> erreurs) {
        File fo;
        block12: {
            fo = null;
            try {
                ZipEntry entry;
                int nbFichier = 0;
                BufferedOutputStream dest = null;
                File fi = new File(nomFichier);
                FileInputStream fis = new FileInputStream(fi);
                ZipInputStream zis = new ZipInputStream(new BufferedInputStream(fis));
                while ((entry = zis.getNextEntry()) != null) {
                    if (++nbFichier <= 1) {
                        String foName;
                        byte[] data = new byte[2048];
                        fo = new File(repDest + "/" + entry.getName());
                        String fiName = fi.getName().substring(0, fi.getName().length() - 4);
                        if (fiName.equals(foName = fo.getName().substring(0, fo.getName().length() - 4))) {
                            int count;
                            FileOutputStream fos = new FileOutputStream(fo);
                            dest = new BufferedOutputStream(fos, 2048);
                            while ((count = zis.read(data, 0, 2048)) != -1) {
                                dest.write(data, 0, count);
                            }
                            dest.flush();
                            dest.close();
                            continue;
                        }
                        if (erreurs == null) continue;
                        erreurs.add("Le nom du fichier d\u00e9compress\u00e9 est diff\u00e9rent du fichier .zip");
                        fo = null;
                        break;
                    }
                    if (fo != null) {
                        fo.delete();
                    }
                    if (erreurs == null) continue;
                    erreurs.add("Le fichier .zip contient plus d'un fichier");
                    fo = null;
                    break;
                }
                zis.close();
                if (nbFichier == 0 && erreurs != null) {
                    erreurs.add("Le fichier est vide ou n'est pas un fichier .zip valide.");
                    fo = null;
                }
            }
            catch (ZipException ze) {
                if (erreurs != null) {
                    erreurs.add("ZipException : " + ze.getMessage());
                    fo = null;
                }
            }
            catch (IOException io) {
                if (erreurs != null) {
                    erreurs.add("IOException : " + io.getMessage());
                    fo = null;
                }
            }
            catch (Exception e) {
                if (erreurs == null) break block12;
                erreurs.add("Exception : " + e.getCause().getMessage());
                fo = null;
            }
        }
        return fo;
    }

    public static File ZipXml(String nomFichier, String repDest, List<String> erreurs) {
        File fo;
        block7: {
            fo = null;
            try {
                int count;
                File fi = new File(nomFichier);
                fo = new File(repDest, fi.getName().substring(0, fi.getName().length() - 4) + ".zip");
                FileOutputStream dest = new FileOutputStream(fo);
                ZipOutputStream out = new ZipOutputStream(new BufferedOutputStream(dest));
                out.setMethod(8);
                byte[] data = new byte[2048];
                FileInputStream fis = new FileInputStream(fi);
                BufferedInputStream origin = new BufferedInputStream(fis, 2048);
                ZipEntry entry = new ZipEntry(fi.getName());
                out.putNextEntry(entry);
                while ((count = origin.read(data, 0, 2048)) != -1) {
                    out.write(data, 0, count);
                }
                origin.close();
                out.flush();
                out.close();
            }
            catch (ZipException ze) {
                if (erreurs != null) {
                    erreurs.add("ZipException : " + ze.getMessage());
                    fo = null;
                }
            }
            catch (IOException io) {
                if (erreurs != null) {
                    erreurs.add("IOException : " + io.getMessage());
                    fo = null;
                }
            }
            catch (Exception e) {
                if (erreurs == null) break block7;
                erreurs.add("Exception : " + e.getCause().getMessage());
                fo = null;
            }
        }
        return fo;
    }

    public static boolean copierFichier(File srFile, File dtFile, List<String> erreurs) {
        boolean resultat;
        block5: {
            resultat = false;
            try {
                int len;
                FileInputStream in = new FileInputStream(srFile);
                FileOutputStream out = new FileOutputStream(dtFile);
                byte[] buf = new byte[1024];
                while ((len = ((InputStream)in).read(buf)) > 0) {
                    ((OutputStream)out).write(buf, 0, len);
                }
                ((InputStream)in).close();
                ((OutputStream)out).close();
                resultat = true;
            }
            catch (FileNotFoundException ex) {
                if (erreurs != null) {
                    erreurs.add(ex.getMessage());
                }
            }
            catch (IOException e) {
                if (erreurs == null) break block5;
                erreurs.add(e.getMessage());
            }
        }
        return resultat;
    }

    public static boolean formatNomFichierValide(String nomFichier, String extension) {
        String[] elements;
        boolean resultat = false;
        if (nomFichier.startsWith("SIMOC_") && nomFichier.endsWith(extension) && (elements = nomFichier.substring(6, nomFichier.indexOf(extension)).split("_")).length == 4 && XmlUtils.isDate(elements[2], "yyyymmdd") && elements[3].matches("^[0-9]{3}$")) {
            if (elements[0].equals("EDE")) {
                if (elements[1].matches("^[0-9a-zA-Z]{3}IPG$") || elements[1].matches("^[0-9a-zA-Z]{3}ARS$")) {
                    resultat = true;
                }
            } else if (elements[0].equals("EXPL")) {
                if (elements[1].matches("^FR[0-9]{8}$")) {
                    resultat = true;
                }
            } else if (elements[0].equals("ABAT")) {
                if (elements[1].matches("^FR[0-9a-zA-Z]{7,8}$")) {
                    resultat = true;
                }
            } else if (elements[0].equals("DELEG") && (elements[1].equals("OVINFOS") || elements[1].matches("^FR[0-9a-zA-Z]{9}$"))) {
                resultat = true;
            }
        }
        return resultat;
    }

    public static boolean isDate(String data, String pattern) {
        if (data == null || data.equals("")) {
            return false;
        }
        SimpleDateFormat formatter = new SimpleDateFormat(pattern);
        Date date = null;
        try {
            date = formatter.parse(data);
        }
        catch (ParseException e) {
            return false;
        }
        String dateReverse = formatter.format(date);
        return data.equals(dateReverse);
    }
}

