/*
 * Decompiled with CFR 0.152.
 */
package com.teamlog.simoc.xml;

import com.teamlog.simoc.xml.MsgErr;
import com.teamlog.simoc.xml.Utils;
import com.teamlog.simoc.xmlObject.Adresse;
import com.teamlog.simoc.xmlObject.Anomalie;
import com.teamlog.simoc.xmlObject.Chargement;
import com.teamlog.simoc.xmlObject.Circulation;
import com.teamlog.simoc.xmlObject.CirculationOrienteeChargement;
import com.teamlog.simoc.xmlObject.CirculationOrienteeDechargement;
import com.teamlog.simoc.xmlObject.Collecte;
import com.teamlog.simoc.xmlObject.Dechargement;
import com.teamlog.simoc.xmlObject.Destination;
import com.teamlog.simoc.xmlObject.Immatriculation;
import com.teamlog.simoc.xmlObject.NotificationMouvementLotOvinCaprin;
import com.teamlog.simoc.xmlObject.OCAnomalyCodeType;
import com.teamlog.simoc.xmlObject.Organisation;
import com.teamlog.simoc.xmlObject.OrganisationTransport;
import com.teamlog.simoc.xmlObject.Party;
import com.teamlog.simoc.xmlObject.Personne;
import com.teamlog.simoc.xmlObject.Provenance;
import com.teamlog.simoc.xmlObject.Registration;
import com.teamlog.simoc.xmlObject.Validation;
import com.teamlog.simoc.xmlObject.Vehicule;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;

public class Controle {
    private static final String FILE_NAME = "codes-references";
    private static final String KEY_CODE_EMETTEUR = "codes.emetteur";
    private static final String KEY_CODE_CREATEUR = "codes.createur";
    private static final String CODE_FR = "FR";
    private static final String TYPE_BELVR = "BELVR";
    private static final String TYPE_BOPAV = "BOPAV";
    private static final String TYPE_BLIPG = "BLIPG";
    private static final String TYPE_BDELG = "BDELG";
    private static final String TYPE_BNSIMOC = "BNSIMOC";
    private static final String TYPE_BDNI = "BDNI";
    private static final String TYPE_BNOVINFOS = "BNOVINFOS";
    private static final String IMMA_NUM_EXPLOIT = "NumeroExploitation";
    private static final String IMMA_NUM_AGREMENT = "NumeroAgrementSanitaire";
    private static final String IMMA_CODE_MOIPG = "CodeMOIPG";
    private static final String IMMA_NUM_DELEGATAIRE = "NumeroStructureDelegataire";
    private static final String IMMA_NUM_SIREN = "NumeroSIREN";
    private static final String IMMA_CERTIF_ECHANGE = "CertificatEchange";
    private static final String IMMA_CERTIF_IMPORT = "CertificatImport";
    private static final String IMMA_CERTIF_UE = "CertificatUE";
    private static final String IMMA_CERTIF_PAYS_TIERS = "CertificatPaysTiers";
    private static final String CATEGORIE_ACTEUR_10 = "10";
    private static final String CATEGORIE_ACTEUR_31 = "31";
    private static final String CATEGORIE_ACTEUR_32 = "32";
    private static final String CATEGORIE_ACTEUR_34 = "34";
    private static final String CATEGORIE_ACTEUR_40 = "40";
    private static final String TYPE_NUM_DDSV = "NumeroDDSV";
    private static final String INCONNU = "INCONNU";
    private static final String ETRANGER = "ETRANGER";
    private static final String NUM_INEXISTANT = "Numero Inexistant";
    private static XMLGregorianCalendar dateCreation = null;
    private static List<String> codesEmetteur = null;
    private static List<String> codesCreateur = null;
    private static HashMap<String, List<String>> emmetteursCreateurs = null;

    public static boolean VerifierCoherence(NotificationMouvementLotOvinCaprin mvtOC, List<String> erreursEntete, String nomFichier, String versionSchemaReference) {
        List<Circulation> lst;
        int nbErr = 0;
        erreursEntete.clear();
        dateCreation = mvtOC.getCreation();
        Controle.ControlerEntete(mvtOC, erreursEntete, nomFichier, versionSchemaReference);
        Controle.ControleBalisesGenerales(mvtOC, versionSchemaReference);
        if (mvtOC.getCirculationOrienteeChargement() != null && !mvtOC.getCirculationOrienteeChargement().isEmpty()) {
            lst = mvtOC.getCirculationOrienteeChargement();
            for (CirculationOrienteeChargement circulationOrienteeChargement : lst) {
                Controle.ControlerCirculationOrienteeChargement(circulationOrienteeChargement, versionSchemaReference);
            }
        }
        if (mvtOC.getCirculationOrienteeDechargement() != null && !mvtOC.getCirculationOrienteeDechargement().isEmpty()) {
            lst = mvtOC.getCirculationOrienteeDechargement();
            for (CirculationOrienteeDechargement circulationOrienteeDechargement : lst) {
                Controle.ControlerCirculationOrienteeDechargement(circulationOrienteeDechargement, versionSchemaReference);
            }
        }
        if (mvtOC.getCollecte() != null) {
            List<Collecte> collectes = mvtOC.getCollecte();
            for (Collecte collecte : collectes) {
                nbErr += collecte.getValidation().getAnomalie().size();
            }
        }
        if (mvtOC.getCirculationOrienteeChargement() != null) {
            lst = mvtOC.getCirculationOrienteeChargement();
            for (CirculationOrienteeChargement circulationOrienteeChargement : lst) {
                nbErr += circulationOrienteeChargement.getValidation().getAnomalie().size();
            }
        }
        if (mvtOC.getCirculationOrienteeDechargement() != null) {
            lst = mvtOC.getCirculationOrienteeDechargement();
            for (CirculationOrienteeDechargement circulationOrienteeDechargement : lst) {
                nbErr += circulationOrienteeDechargement.getValidation().getAnomalie().size();
            }
        }
        mvtOC.setNbEvtErreur(Long.valueOf(nbErr));
        if (nbErr > 0) {
            mvtOC.setFichierRejete(true);
        } else {
            mvtOC.setFichierRejete(false);
        }
        return mvtOC.isFichierRejete() == false && erreursEntete.size() == 0;
    }

    public static void PreparerReponse(NotificationMouvementLotOvinCaprin mvtOC) {
        Organisation createur;
        List<Circulation> lstCirculation;
        mvtOC.setDocumentOrigine(mvtOC.getIdentification());
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTimeInMillis(System.currentTimeMillis());
        DatatypeFactory df = null;
        try {
            df = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException e) {
            System.err.println(e.getMessage());
        }
        XMLGregorianCalendar dd = df.newXMLGregorianCalendar(gc);
        dd.setTimezone(0);
        mvtOC.setCreation(dd);
        Party issuer = mvtOC.getIssuer();
        mvtOC.setIssuer(mvtOC.getOwner());
        mvtOC.setOwner(issuer);
        List<Collecte> collectes = mvtOC.getCollecte();
        for (Collecte collecte : collectes) {
            Organisation organisation = collecte.getCreateur();
            collecte.setCreateur(collecte.getDestinataire());
            collecte.setDestinataire(organisation);
        }
        if (mvtOC.getCirculationOrienteeChargement() != null && !mvtOC.getCirculationOrienteeChargement().isEmpty()) {
            lstCirculation = mvtOC.getCirculationOrienteeChargement();
            for (CirculationOrienteeChargement circulationOrienteeChargement : lstCirculation) {
                createur = circulationOrienteeChargement.getCreateur();
                circulationOrienteeChargement.setCreateur(circulationOrienteeChargement.getDestinataire());
                circulationOrienteeChargement.setDestinataire(createur);
            }
        }
        if (mvtOC.getCirculationOrienteeDechargement() != null && !mvtOC.getCirculationOrienteeDechargement().isEmpty()) {
            lstCirculation = mvtOC.getCirculationOrienteeDechargement();
            for (CirculationOrienteeDechargement circulationOrienteeDechargement : lstCirculation) {
                createur = circulationOrienteeDechargement.getCreateur();
                circulationOrienteeDechargement.setCreateur(circulationOrienteeDechargement.getDestinataire());
                circulationOrienteeDechargement.setDestinataire(createur);
            }
        }
    }

    private static void ControlerEntete(NotificationMouvementLotOvinCaprin mvtOC, List<String> erreursEntete, String nomFichier, String versionSchemaReference) {
        Validation validation;
        int nbEnregistrement = 0;
        boolean erreurJG907 = false;
        Controle.ControlerIssuerOwner(mvtOC.getIssuer().getRegistration(), mvtOC.getOwner().getRegistration(), erreursEntete, versionSchemaReference);
        if (nomFichier.startsWith("SIMOC_")) {
            List<Circulation> lst;
            if (mvtOC.getDocumentOrigine() != null || mvtOC.isFichierRejete() != null || mvtOC.getNbEvtErreur() != null) {
                erreurJG907 = true;
            }
            if (mvtOC.getCirculationOrienteeChargement() != null && !mvtOC.getCirculationOrienteeChargement().isEmpty()) {
                lst = mvtOC.getCirculationOrienteeChargement();
                for (CirculationOrienteeChargement circulationOrienteeChargement : lst) {
                    if (circulationOrienteeChargement.getValidation() == null || circulationOrienteeChargement.getValidation().getAnomalie() == null && circulationOrienteeChargement.getValidation().isQualification() == null) continue;
                    erreurJG907 = true;
                    break;
                }
            }
            if (mvtOC.getCirculationOrienteeDechargement() != null && !mvtOC.getCirculationOrienteeDechargement().isEmpty()) {
                lst = mvtOC.getCirculationOrienteeDechargement();
                for (CirculationOrienteeDechargement circulationOrienteeDechargement : lst) {
                    if (circulationOrienteeDechargement.getValidation() == null || circulationOrienteeDechargement.getValidation().getAnomalie() == null && circulationOrienteeDechargement.getValidation().isQualification() == null) continue;
                    erreurJG907 = true;
                    break;
                }
            }
            if (mvtOC.getCollecte() != null) {
                List<Collecte> collectes = mvtOC.getCollecte();
                for (Collecte collecte : collectes) {
                    if (collecte.getValidation() == null || collecte.getValidation().getAnomalie() == null && collecte.getValidation().isQualification() == null) continue;
                    erreurJG907 = true;
                    break;
                }
            }
            if (erreurJG907) {
                erreursEntete.add(MsgErr.getMsgErr("JG907", versionSchemaReference));
            }
        }
        if (mvtOC.getIssuer().getRegistration().getIdentifierType().value().equals(TYPE_BDELG)) {
            if (mvtOC.getCirculationOrienteeChargement() != null && !mvtOC.getCirculationOrienteeChargement().isEmpty()) {
                validation = new Validation();
                validation.getAnomalie().add(Controle.creerAnomalie("J060", versionSchemaReference));
                validation.setQualification(false);
                mvtOC.getCirculationOrienteeChargement().get(0).setValidation(validation);
            }
            if (mvtOC.getCirculationOrienteeDechargement() != null && !mvtOC.getCirculationOrienteeDechargement().isEmpty()) {
                validation = new Validation();
                validation.getAnomalie().add(Controle.creerAnomalie("J060", versionSchemaReference));
                validation.setQualification(false);
                mvtOC.getCirculationOrienteeDechargement().get(0).setValidation(validation);
            }
        } else if (mvtOC.getCollecte() != null && !mvtOC.getCollecte().isEmpty()) {
            validation = new Validation();
            validation.getAnomalie().add(Controle.creerAnomalie("J061", versionSchemaReference));
            validation.setQualification(false);
            mvtOC.getCollecte().get(0).setValidation(validation);
        }
        if (mvtOC.getCollecte() != null) {
            nbEnregistrement = mvtOC.getCollecte().size();
        }
        if (mvtOC.getCirculationOrienteeChargement() != null && !mvtOC.getCirculationOrienteeChargement().isEmpty()) {
            nbEnregistrement += mvtOC.getCirculationOrienteeChargement().size();
        }
        if (mvtOC.getCirculationOrienteeDechargement() != null && !mvtOC.getCirculationOrienteeDechargement().isEmpty()) {
            nbEnregistrement += mvtOC.getCirculationOrienteeDechargement().size();
        }
        if (mvtOC.getLineCount() != (long)nbEnregistrement) {
            erreursEntete.add(MsgErr.getMsgErr("JG900", versionSchemaReference));
        }
        if (nbEnregistrement > 200) {
            erreursEntete.add(MsgErr.getMsgErr("JG973", versionSchemaReference));
        }
    }

    private static void ControlerIssuerOwner(Registration issuer, Registration onwer, List<String> erreurs, String versionSchemaReference) {
        Controle.ControleRegistration(issuer, erreurs, versionSchemaReference);
        Controle.ControleRegistration(onwer, erreurs, versionSchemaReference);
        if (issuer.getIdentifierType().value().equals(TYPE_BELVR) && !onwer.getIdentifierType().value().equals(TYPE_BLIPG)) {
            erreurs.add(MsgErr.getMsgErr("JG910", versionSchemaReference));
        }
        if (issuer.getIdentifierType().value().equals(TYPE_BOPAV) && !onwer.getIdentifierType().value().equals(TYPE_BLIPG) && !onwer.getIdentifierType().value().equals(TYPE_BNSIMOC)) {
            erreurs.add(MsgErr.getMsgErr("JG911", versionSchemaReference));
        }
        if (issuer.getIdentifierType().value().equals(TYPE_BDELG) && !onwer.getIdentifierType().value().equals(TYPE_BNSIMOC)) {
            erreurs.add(MsgErr.getMsgErr("JG912", versionSchemaReference));
        }
        if (issuer.getIdentifierType().value().equals(TYPE_BLIPG) && !onwer.getIdentifierType().value().equals(TYPE_BNSIMOC)) {
            erreurs.add(MsgErr.getMsgErr("JG913", versionSchemaReference));
        }
    }

    private static void ControleRegistration(Registration registration, List<String> erreurs, String versionSchemaReference) {
        if (registration.getIdentifierType().value().equals(TYPE_BELVR)) {
            if (!Utils.isIdentifiantNational(registration.getIdentifier())) {
                erreurs.add(MsgErr.getMsgErr("JG995", versionSchemaReference));
            }
        } else if (registration.getIdentifierType().value().equals(TYPE_BOPAV)) {
            if (!Utils.isAgrementSanitaire(registration.getIdentifier())) {
                erreurs.add(MsgErr.getMsgErr("JG994", versionSchemaReference));
            }
        } else if (registration.getIdentifierType().value().equals(TYPE_BLIPG)) {
            if (!codesEmetteur.contains(registration.getIdentifier())) {
                erreurs.add(MsgErr.getMsgErr("JG996", versionSchemaReference));
            }
        } else if (registration.getIdentifierType().value().equals(TYPE_BDELG)) {
            if (!registration.getIdentifier().matches("^FR[0-9a-zA-Z]{9}$")) {
                erreurs.add(MsgErr.getMsgErr("JG997", versionSchemaReference));
            }
        } else if (registration.getIdentifierType().value().equals(TYPE_BNSIMOC)) {
            if (!registration.getIdentifier().equals("031BDN")) {
                erreurs.add(MsgErr.getMsgErr("JG998", versionSchemaReference));
            }
        } else {
            erreurs.add(MsgErr.getMsgErr("JG993", versionSchemaReference));
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void ControleBalisesGenerales(NotificationMouvementLotOvinCaprin mvtOC, String versionSchemaReference) {
        List<Circulation> lstCirculation;
        List<Immatriculation> immatCreateur;
        boolean identifiantOk;
        List<Collecte> collectes = mvtOC.getCollecte();
        for (Collecte collecte : collectes) {
            void var5_5;
            Validation validation = collecte.getValidation();
            if (validation == null) {
                Validation validation2 = new Validation();
            }
            boolean numeroDelegataire = false;
            identifiantOk = false;
            immatCreateur = collecte.getCreateur().getImmatriculation();
            for (Immatriculation immatriculation : immatCreateur) {
                if (immatriculation.getTypeIdentifiant().value().equals(IMMA_NUM_DELEGATAIRE)) {
                    numeroDelegataire = true;
                }
                if (collecte.getIdentifiant().length() <= immatriculation.getIdentifiant().length() || !immatriculation.getIdentifiant().equals(collecte.getIdentifiant().substring(1, immatriculation.getIdentifiant().length() + 1))) continue;
                identifiantOk = true;
            }
            if (!numeroDelegataire) {
                var5_5.getAnomalie().add(Controle.creerAnomalie("J062", versionSchemaReference));
            }
            if (!identifiantOk) {
                var5_5.getAnomalie().add(Controle.creerAnomalie("J011", versionSchemaReference));
            }
            var5_5.getAnomalie().addAll(Controle.ControleIssuerCodeAction(mvtOC.getIssuer().getRegistration(), collecte.getCodeAction().value(), versionSchemaReference));
            var5_5.getAnomalie().addAll(Controle.ControleCollecte(collecte, versionSchemaReference));
            var5_5.getAnomalie().addAll(Controle.ControleVehicule(collecte.getVehicule(), versionSchemaReference));
            var5_5.getAnomalie().addAll(Controle.isIdentifiantOK(collecte.getIdentifiant(), mvtOC.getIssuer().getRegistration(), collecte.getCreateur(), versionSchemaReference));
            var5_5.getAnomalie().addAll(Controle.ControleCreateurDestinataire(collecte.getCreateur(), collecte.getDestinataire(), mvtOC.getIssuer().getRegistration(), versionSchemaReference));
            var5_5.getAnomalie().addAll(Controle.ControleOrganisationTransport(collecte.getOrganisationTransport(), versionSchemaReference));
            var5_5.getAnomalie().addAll(Controle.ControleOrganisationTransportVehicule(collecte.getOrganisationTransport(), collecte.getVehicule(), versionSchemaReference));
            var5_5.getAnomalie().addAll(Controle.ControleDate(collecte.getDateDebut(), collecte.getHeureDebut(), versionSchemaReference));
            var5_5.getAnomalie().addAll(Controle.ControleDate(collecte.getDateFin(), collecte.getHeureFin(), versionSchemaReference));
            if (collecte.getChargement() != null) {
                List<Chargement> chargements = collecte.getChargement();
                for (Chargement chargement : chargements) {
                    var5_5.getAnomalie().addAll(Controle.ControleChargement(chargement, versionSchemaReference));
                }
            }
            if (collecte.getDechargement() != null) {
                List<Dechargement> dechargements = collecte.getDechargement();
                for (Dechargement dechargement : dechargements) {
                    var5_5.getAnomalie().addAll(Controle.ControleDechargement(dechargement, versionSchemaReference));
                }
            }
            var5_5.setQualification(var5_5.getAnomalie().size() == 0);
            collecte.setValidation((Validation)var5_5);
        }
        if (mvtOC.getCirculationOrienteeChargement() != null && !mvtOC.getCirculationOrienteeChargement().isEmpty()) {
            lstCirculation = mvtOC.getCirculationOrienteeChargement();
            for (CirculationOrienteeChargement circulationOrienteeChargement : lstCirculation) {
                Validation validation = circulationOrienteeChargement.getValidation();
                if (validation == null) {
                    validation = new Validation();
                }
                identifiantOk = false;
                immatCreateur = circulationOrienteeChargement.getCreateur().getImmatriculation();
                for (Immatriculation immatriculation : immatCreateur) {
                    if (circulationOrienteeChargement.getIdentifiant().length() <= immatriculation.getIdentifiant().length() || !immatriculation.getIdentifiant().equals(circulationOrienteeChargement.getIdentifiant().substring(1, immatriculation.getIdentifiant().length() + 1))) continue;
                    identifiantOk = true;
                }
                if (!identifiantOk) {
                    validation.getAnomalie().add(Controle.creerAnomalie("J011", versionSchemaReference));
                }
                validation.getAnomalie().addAll(Controle.isIdentifiantOK(circulationOrienteeChargement.getIdentifiant(), mvtOC.getIssuer().getRegistration(), circulationOrienteeChargement.getCreateur(), versionSchemaReference));
                validation.getAnomalie().addAll(Controle.ControleCreateurDestinataire(circulationOrienteeChargement.getCreateur(), circulationOrienteeChargement.getDestinataire(), mvtOC.getIssuer().getRegistration(), versionSchemaReference));
                validation.getAnomalie().addAll(Controle.ControleIssuerCodeAction(mvtOC.getIssuer().getRegistration(), circulationOrienteeChargement.getCodeAction().value(), versionSchemaReference));
                validation.getAnomalie().addAll(Controle.ControleVehicule(circulationOrienteeChargement.getVehiculeUtilise(), versionSchemaReference));
                validation.getAnomalie().addAll(Controle.ControleOrganisationTransport(circulationOrienteeChargement.getOrganisationTransport(), versionSchemaReference));
                validation.getAnomalie().addAll(Controle.ControleOrganisationTransportVehicule(circulationOrienteeChargement.getOrganisationTransport(), circulationOrienteeChargement.getVehiculeUtilise(), versionSchemaReference));
                validation.getAnomalie().addAll(Controle.ControleChargement(circulationOrienteeChargement.getChargement(), versionSchemaReference));
                validation.setQualification(validation.getAnomalie().size() == 0);
                circulationOrienteeChargement.setValidation(validation);
            }
        }
        if (mvtOC.getCirculationOrienteeDechargement() != null && !mvtOC.getCirculationOrienteeDechargement().isEmpty()) {
            lstCirculation = mvtOC.getCirculationOrienteeDechargement();
            for (CirculationOrienteeDechargement circulationOrienteeDechargement : lstCirculation) {
                Validation validation = circulationOrienteeDechargement.getValidation();
                if (validation == null) {
                    validation = new Validation();
                }
                identifiantOk = false;
                immatCreateur = circulationOrienteeDechargement.getCreateur().getImmatriculation();
                for (Immatriculation immatriculation : immatCreateur) {
                    if (circulationOrienteeDechargement.getIdentifiant().length() <= immatriculation.getIdentifiant().length() || !immatriculation.getIdentifiant().equals(circulationOrienteeDechargement.getIdentifiant().substring(1, immatriculation.getIdentifiant().length() + 1))) continue;
                    identifiantOk = true;
                }
                if (!identifiantOk) {
                    validation.getAnomalie().add(Controle.creerAnomalie("J011", versionSchemaReference));
                }
                validation.getAnomalie().addAll(Controle.isIdentifiantOK(circulationOrienteeDechargement.getIdentifiant(), mvtOC.getIssuer().getRegistration(), circulationOrienteeDechargement.getCreateur(), versionSchemaReference));
                validation.getAnomalie().addAll(Controle.ControleCreateurDestinataire(circulationOrienteeDechargement.getCreateur(), circulationOrienteeDechargement.getDestinataire(), mvtOC.getIssuer().getRegistration(), versionSchemaReference));
                validation.getAnomalie().addAll(Controle.ControleIssuerCodeAction(mvtOC.getIssuer().getRegistration(), circulationOrienteeDechargement.getCodeAction().value(), versionSchemaReference));
                validation.getAnomalie().addAll(Controle.ControleVehicule(circulationOrienteeDechargement.getVehiculeUtilise(), versionSchemaReference));
                validation.getAnomalie().addAll(Controle.ControleOrganisationTransport(circulationOrienteeDechargement.getOrganisationTransport(), versionSchemaReference));
                validation.getAnomalie().addAll(Controle.ControleOrganisationTransportVehicule(circulationOrienteeDechargement.getOrganisationTransport(), circulationOrienteeDechargement.getVehiculeUtilise(), versionSchemaReference));
                validation.getAnomalie().addAll(Controle.ControleDechargement(circulationOrienteeDechargement.getDechargement(), versionSchemaReference));
                validation.setQualification(validation.getAnomalie().size() == 0);
                circulationOrienteeDechargement.setValidation(validation);
            }
        }
    }

    private static List<Anomalie> isIdentifiantOK(String identifiant, Registration issuer, Organisation createur, String versionSchemaReference) {
        ArrayList<Anomalie> erreurs = new ArrayList<Anomalie>();
        String identifierType = issuer.getIdentifierType().value();
        Anomalie anomalie = new Anomalie();
        switch (identifiant.charAt(0)) {
            case 'E': {
                if (identifierType.equals(TYPE_BELVR) || identifierType.equals(TYPE_BOPAV)) break;
                anomalie.setCodeAnomalie(OCAnomalyCodeType.fromValue("J006"));
                break;
            }
            case 'A': {
                if (identifierType.equals(TYPE_BOPAV)) break;
                anomalie.setCodeAnomalie(OCAnomalyCodeType.fromValue("J007"));
                break;
            }
            case 'D': {
                if (identifierType.equals(TYPE_BDELG)) break;
                anomalie.setCodeAnomalie(OCAnomalyCodeType.fromValue("J008"));
                break;
            }
            case 'B': {
                if (identifierType.equals(TYPE_BLIPG)) break;
                anomalie.setCodeAnomalie(OCAnomalyCodeType.fromValue("J009"));
                break;
            }
            default: {
                anomalie.setCodeAnomalie(OCAnomalyCodeType.fromValue("J010"));
            }
        }
        if (anomalie.getCodeAnomalie() != null) {
            anomalie.setTypeAnomalie("1");
            anomalie.setLibelleAnomalie(MsgErr.getMsgErr(anomalie.getCodeAnomalie().value(), versionSchemaReference));
            erreurs.add(anomalie);
        }
        return erreurs;
    }

    private static List<Anomalie> ControleIssuerCodeAction(Registration issuer, String CodeAction, String versionSchemaReference) {
        ArrayList<Anomalie> lstAnomalie = new ArrayList<Anomalie>();
        if (issuer.getIdentifierType().value().equals(TYPE_BELVR) || issuer.getIdentifierType().value().equals(TYPE_BOPAV) || issuer.getIdentifierType().value().equals(TYPE_BDELG) || issuer.getIdentifierType().value().equals(TYPE_BLIPG) || issuer.getIdentifierType().value().equals(TYPE_BNOVINFOS)) {
            boolean isOk = false;
            if (!CodeAction.equals("INF")) {
                isOk = true;
            }
            if (!isOk) {
                lstAnomalie.add(Controle.creerAnomalie("J137", versionSchemaReference));
            }
        }
        return lstAnomalie;
    }

    private static List<Anomalie> ControleCollecte(Collecte collecte, String versionSchemaReference) {
        ArrayList<Anomalie> lstAnomalie = new ArrayList<Anomalie>();
        List<Dechargement> lstDechargement = collecte.getDechargement();
        List<Chargement> lstChargement = collecte.getChargement();
        for (Dechargement mouvementOvinCaprin : lstDechargement) {
        }
        for (Chargement chargement : lstChargement) {
        }
        if (collecte.getChargement() != null) {
            for (Chargement chargement : lstChargement) {
                if (chargement.getCategorieActeur() != null && chargement.getCategorieActeur().matches("^[ ]*$")) {
                    lstAnomalie.add(Controle.creerAnomalie("J141", versionSchemaReference));
                }
                if (chargement.getExploitationChargement() == null || chargement.getExploitationChargement().getNomOrganisation() == null || !chargement.getExploitationChargement().getNomOrganisation().matches("^[ ]*$")) continue;
                lstAnomalie.add(Controle.creerAnomalie("J141", versionSchemaReference));
            }
        }
        if (collecte.getCodeAction() != null && collecte.getCodeAction().value() != null && collecte.getCodeAction().value().matches("^[ ]*$")) {
            lstAnomalie.add(Controle.creerAnomalie("J141", versionSchemaReference));
        }
        if (collecte.getCommentaire() != null && collecte.getCommentaire().matches("^[ ]*$")) {
            lstAnomalie.add(Controle.creerAnomalie("J141", versionSchemaReference));
        }
        if (collecte.getCreateur() != null && collecte.getCreateur().getNomOrganisation() != null && collecte.getCreateur().getNomOrganisation().matches("^[ ]*$")) {
            lstAnomalie.add(Controle.creerAnomalie("J141", versionSchemaReference));
        }
        if (collecte.getDechargement() != null) {
            for (Dechargement dechargement : lstDechargement) {
                if (dechargement.getCategorieActeur() != null && dechargement.getCategorieActeur().matches("^[ ]*$")) {
                    lstAnomalie.add(Controle.creerAnomalie("J141", versionSchemaReference));
                }
                if (dechargement.getExploitationDeDechargement() == null || dechargement.getExploitationDeDechargement().getNomOrganisation() == null || !dechargement.getExploitationDeDechargement().getNomOrganisation().matches("^[ ]*$")) continue;
                lstAnomalie.add(Controle.creerAnomalie("J141", versionSchemaReference));
            }
        }
        if (collecte.getDestinataire() != null && collecte.getDestinataire().getNomOrganisation() != null && collecte.getDestinataire().getNomOrganisation().matches("^[ ]*$")) {
            lstAnomalie.add(Controle.creerAnomalie("J141", versionSchemaReference));
        }
        if (collecte.getIdentifiant() != null && collecte.getIdentifiant().matches("^[ ]*$")) {
            lstAnomalie.add(Controle.creerAnomalie("J141", versionSchemaReference));
        }
        if (collecte.getOrganisationTransport() != null) {
            if (collecte.getOrganisationTransport().getNomOrganisation() != null && collecte.getOrganisationTransport().getNomOrganisation().matches("^[ ]*$")) {
                lstAnomalie.add(Controle.creerAnomalie("J141", versionSchemaReference));
            }
            if (collecte.getOrganisationTransport().getTypeTransporteur() != null && collecte.getOrganisationTransport().getTypeTransporteur().value() != null && collecte.getOrganisationTransport().getTypeTransporteur().value().matches("^[ ]*$")) {
                lstAnomalie.add(Controle.creerAnomalie("J141", versionSchemaReference));
            }
        }
        if (collecte.getVehicule() != null) {
            if (collecte.getVehicule().getNumeroMineralogique() != null && collecte.getVehicule().getNumeroMineralogique().matches("^[ ]*$")) {
                lstAnomalie.add(Controle.creerAnomalie("J141", versionSchemaReference));
            }
            if (collecte.getVehicule().getTypeVehicule() != null && collecte.getVehicule().getTypeVehicule().matches("^[ ]*$")) {
                lstAnomalie.add(Controle.creerAnomalie("J141", versionSchemaReference));
            }
        }
        return lstAnomalie;
    }

    private static List<Anomalie> ControleVehicule(Vehicule vehicule, String versionSchemaReference) {
        ArrayList<Anomalie> lstAnomalie = new ArrayList<Anomalie>();
        if (vehicule != null) {
            if (vehicule.getNumeroMineralogique().indexOf(" ") > -1) {
                lstAnomalie.add(Controle.creerAnomalie("J140", versionSchemaReference));
            }
            if (!vehicule.getNumeroMineralogique().matches("^[0-9A-Z]*$")) {
                lstAnomalie.add(Controle.creerAnomalie("J140", versionSchemaReference));
            }
        }
        return lstAnomalie;
    }

    private static List<Anomalie> ControleCreateurDestinataire(Organisation createur, Organisation destinataire, Registration issuer, String versionSchemaReference) {
        String string;
        List<String> lstCreateur;
        ArrayList<Anomalie> lstAnomalie = new ArrayList<Anomalie>();
        List<Immatriculation> immatCreateur = createur.getImmatriculation();
        if (immatCreateur.size() > 1) {
            lstAnomalie.add(Controle.creerAnomalie("J082", versionSchemaReference));
        }
        for (Immatriculation immatriculation : immatCreateur) {
            String erreur = Controle.isImmatriculationOk(immatriculation);
            if (erreur == null) continue;
            lstAnomalie.add(Controle.creerAnomalie(erreur, versionSchemaReference));
        }
        List<Immatriculation> immatDestinataire = destinataire.getImmatriculation();
        if (immatDestinataire.size() > 1) {
            lstAnomalie.add(Controle.creerAnomalie("J082", versionSchemaReference));
        }
        for (Immatriculation immatriculation : immatDestinataire) {
            String erreur = Controle.isImmatriculationOk(immatriculation);
            if (erreur == null) continue;
            lstAnomalie.add(Controle.creerAnomalie(erreur, versionSchemaReference));
        }
        if (issuer.getIdentifierType().value().equals(TYPE_BELVR) || issuer.getIdentifierType().value().equals(TYPE_BOPAV) || issuer.getIdentifierType().value().equals(TYPE_BDELG)) {
            boolean bl;
            boolean bl2 = false;
            List<Immatriculation> lstImmat = createur.getImmatriculation();
            for (Immatriculation immatriculation2 : lstImmat) {
                if (!issuer.getIdentifier().equals(immatriculation2.getIdentifiant())) continue;
                bl = true;
            }
            if (!bl) {
                lstAnomalie.add(Controle.creerAnomalie("J135", versionSchemaReference));
            }
        }
        if (issuer.getIdentifierType().value().equals(TYPE_BLIPG) && (lstCreateur = emmetteursCreateurs.get(string = issuer.getIdentifier())) != null) {
            boolean IdentifiantOk = false;
            List<Immatriculation> lstImmat = createur.getImmatriculation();
            for (Immatriculation immatriculation2 : lstImmat) {
                if (!lstCreateur.contains(immatriculation2.getIdentifiant())) continue;
                IdentifiantOk = true;
            }
            if (!IdentifiantOk) {
                lstAnomalie.add(Controle.creerAnomalie("J135", versionSchemaReference));
            }
        }
        boolean bl = false;
        List<Immatriculation> lstImmatCrea = createur.getImmatriculation();
        for (Immatriculation immatCrea : lstImmatCrea) {
            boolean bl3;
            List<Immatriculation> lstImmatDest;
            if (immatCrea.getTypeIdentifiant().value().equals(IMMA_NUM_EXPLOIT)) {
                lstImmatDest = destinataire.getImmatriculation();
                for (Immatriculation immatDest : lstImmatDest) {
                    if (!immatDest.getTypeIdentifiant().value().equals(IMMA_CODE_MOIPG) && !immatDest.getTypeIdentifiant().value().equals(TYPE_BDNI)) continue;
                    bl3 = true;
                }
            } else if (immatCrea.getTypeIdentifiant().value().equals(IMMA_NUM_AGREMENT)) {
                lstImmatDest = destinataire.getImmatriculation();
                for (Immatriculation immatDest : lstImmatDest) {
                    if (!immatDest.getTypeIdentifiant().value().equals(TYPE_BDNI)) continue;
                    bl3 = true;
                }
            } else if (immatCrea.getTypeIdentifiant().value().equals(IMMA_NUM_DELEGATAIRE)) {
                lstImmatDest = destinataire.getImmatriculation();
                for (Immatriculation immatDest : lstImmatDest) {
                    if (!immatDest.getTypeIdentifiant().value().equals(TYPE_BDNI)) continue;
                    bl3 = true;
                }
            } else if (immatCrea.getTypeIdentifiant().value().equals(IMMA_CODE_MOIPG)) {
                lstImmatDest = destinataire.getImmatriculation();
                for (Immatriculation immatDest : lstImmatDest) {
                    if (!immatDest.getTypeIdentifiant().value().equals(TYPE_BDNI)) continue;
                    bl3 = true;
                }
            }
            if (bl3) continue;
            lstAnomalie.add(Controle.creerAnomalie("J136", versionSchemaReference));
        }
        return lstAnomalie;
    }

    private static String isImmatriculationOk(Immatriculation immatriculation) {
        String erreur = null;
        if (immatriculation.getTypeIdentifiant().value().equals(IMMA_NUM_EXPLOIT)) {
            if (!Utils.isIdentifiantNational(immatriculation.getIdentifiant())) {
                erreur = "J085";
            }
        } else if (immatriculation.getTypeIdentifiant().value().equals(IMMA_NUM_AGREMENT)) {
            if (!Utils.isAgrementSanitaire(immatriculation.getIdentifiant())) {
                erreur = "J084";
            }
        } else if (immatriculation.getTypeIdentifiant().value().equals(IMMA_CODE_MOIPG)) {
            if (!codesCreateur.contains(immatriculation.getIdentifiant())) {
                erreur = "J086";
            }
        } else if (immatriculation.getTypeIdentifiant().value().equals(IMMA_NUM_DELEGATAIRE)) {
            if (!immatriculation.getIdentifiant().matches("^FR[0-9a-zA-Z]{9}$")) {
                erreur = "J087";
            }
        } else if (immatriculation.getTypeIdentifiant().value().equals(TYPE_BDNI)) {
            if (!immatriculation.getIdentifiant().equals("031BDN")) {
                erreur = "J088";
            }
        } else {
            erreur = "J083";
        }
        return erreur;
    }

    private static List<Anomalie> ControleOrganisationTransport(OrganisationTransport organisation, String versionSchemaReference) {
        ArrayList<Anomalie> anomalies = new ArrayList<Anomalie>();
        if (organisation != null) {
            boolean typeOk = false;
            List<Immatriculation> lstImmat = organisation.getImmatriculation();
            for (Immatriculation immatriculation : lstImmat) {
                if (!immatriculation.getTypeIdentifiant().value().equals(TYPE_NUM_DDSV)) continue;
                typeOk = true;
                if (immatriculation.getIdentifiant().equals(INCONNU) || immatriculation.getIdentifiant().matches("^[0-9A-Z]*$")) continue;
                anomalies.add(Controle.creerAnomalie("J012", versionSchemaReference));
            }
            if (!typeOk) {
                anomalies.add(Controle.creerAnomalie("J004", versionSchemaReference));
            }
        }
        return anomalies;
    }

    private static List<Anomalie> ControleOrganisationTransportVehicule(OrganisationTransport organisation, Vehicule vehicule, String versionSchemaReference) {
        ArrayList<Anomalie> anomalies = new ArrayList<Anomalie>();
        if (organisation != null && vehicule == null) {
            anomalies.add(Controle.creerAnomalie("J003", versionSchemaReference));
        }
        if (organisation == null && vehicule != null) {
            anomalies.add(Controle.creerAnomalie("J003", versionSchemaReference));
        }
        return anomalies;
    }

    private static List<Anomalie> ControleChargement(Chargement chargement, String versionSchemaReference) {
        ArrayList<Anomalie> anomalies = new ArrayList<Anomalie>();
        if (chargement != null) {
            if (!(chargement.getCategorieActeur().equals(CATEGORIE_ACTEUR_10) || chargement.getCategorieActeur().equals(CATEGORIE_ACTEUR_31) || chargement.getCategorieActeur().equals(CATEGORIE_ACTEUR_32))) {
                anomalies.add(Controle.creerAnomalie("J020", versionSchemaReference));
            }
            if (chargement.getNombreCaprins() == new BigInteger("0") && chargement.getNombreOvins() == new BigInteger("0")) {
                anomalies.add(Controle.creerAnomalie("J021", versionSchemaReference));
            }
            List<Immatriculation> lstImma = chargement.getExploitationChargement().getImmatriculation();
            boolean numExploitation = false;
            for (Immatriculation immatriculation : lstImma) {
                if (immatriculation.getTypeIdentifiant().value().equals(IMMA_NUM_EXPLOIT)) {
                    numExploitation = true;
                    if (!Utils.isIdentifiantNational(immatriculation.getIdentifiant())) {
                        anomalies.add(Controle.creerAnomalie("J023", versionSchemaReference));
                    }
                }
                if (!immatriculation.getTypeIdentifiant().value().equals(IMMA_NUM_SIREN) || Utils.isNumeroSiren(immatriculation.getIdentifiant())) continue;
                anomalies.add(Controle.creerAnomalie("J030", versionSchemaReference));
            }
            if (!numExploitation) {
                anomalies.add(Controle.creerAnomalie("J022", versionSchemaReference));
            }
            if (chargement.getCategorieActeur().equals(CATEGORIE_ACTEUR_31)) {
                boolean typeExploit = false;
                boolean typeSiren = false;
                for (Immatriculation immatriculation : lstImma) {
                    if (immatriculation.getTypeIdentifiant().value().equals(IMMA_NUM_SIREN)) {
                        typeSiren = true;
                    }
                    if (!immatriculation.getTypeIdentifiant().value().equals(IMMA_NUM_EXPLOIT)) continue;
                    typeExploit = true;
                }
                if (!typeExploit || !typeSiren) {
                    anomalies.add(Controle.creerAnomalie("J029", versionSchemaReference));
                }
            }
            anomalies.addAll(Controle.ControleDate(chargement.getDate(), chargement.getHeure(), versionSchemaReference));
        }
        return anomalies;
    }

    private static List<Anomalie> ControleDechargement(Dechargement dechargement, String versionSchemaReference) {
        ArrayList<Anomalie> anomalies = new ArrayList<Anomalie>();
        if (dechargement != null) {
            if (!(dechargement.getCategorieActeur().equals(CATEGORIE_ACTEUR_10) || dechargement.getCategorieActeur().equals(CATEGORIE_ACTEUR_31) || dechargement.getCategorieActeur().equals(CATEGORIE_ACTEUR_32) || dechargement.getCategorieActeur().equals(CATEGORIE_ACTEUR_40))) {
                anomalies.add(Controle.creerAnomalie("J024", versionSchemaReference));
            }
            if (dechargement.getNombreCaprins() == new BigInteger("0") && dechargement.getNombreOvins() == new BigInteger("0") && dechargement.getNombreMorts() == new BigInteger("0")) {
                anomalies.add(Controle.creerAnomalie("J025", versionSchemaReference));
            }
            List<Immatriculation> lstImma = dechargement.getExploitationDeDechargement().getImmatriculation();
            for (Immatriculation immatriculation : lstImma) {
                if (immatriculation.getTypeIdentifiant().value().equals(IMMA_NUM_SIREN) && !Utils.isNumeroSiren(immatriculation.getIdentifiant())) {
                    anomalies.add(Controle.creerAnomalie("J030", versionSchemaReference));
                }
                if (immatriculation.getTypeIdentifiant().value().equals(IMMA_NUM_EXPLOIT) && !Utils.isIdentifiantNational(immatriculation.getIdentifiant())) {
                    anomalies.add(Controle.creerAnomalie("J026", versionSchemaReference));
                }
                if (!immatriculation.getTypeIdentifiant().value().equals(IMMA_NUM_AGREMENT) || Utils.isAgrementSanitaire(immatriculation.getIdentifiant())) continue;
                anomalies.add(Controle.creerAnomalie("J031", versionSchemaReference));
            }
            if (dechargement.getCategorieActeur().equals(CATEGORIE_ACTEUR_31)) {
                boolean typeExploit = false;
                boolean typeSiren = false;
                for (Immatriculation immatriculation : lstImma) {
                    if (immatriculation.getTypeIdentifiant().value().equals(IMMA_NUM_SIREN)) {
                        typeSiren = true;
                    }
                    if (!immatriculation.getTypeIdentifiant().value().equals(IMMA_NUM_EXPLOIT)) continue;
                    typeExploit = true;
                }
                if (!typeExploit || !typeSiren) {
                    anomalies.add(Controle.creerAnomalie("J027", versionSchemaReference));
                }
            }
            if (dechargement.getCategorieActeur().equals(CATEGORIE_ACTEUR_40)) {
                boolean numAgrement = false;
                for (Immatriculation immatriculation : lstImma) {
                    if (!immatriculation.getTypeIdentifiant().value().equals(IMMA_NUM_AGREMENT)) continue;
                    numAgrement = true;
                }
                if (!numAgrement) {
                    anomalies.add(Controle.creerAnomalie("J028", versionSchemaReference));
                }
            }
            if (dechargement.getCategorieActeur().equals(CATEGORIE_ACTEUR_10) || dechargement.getCategorieActeur().equals(CATEGORIE_ACTEUR_32)) {
                boolean numExploit = false;
                for (Immatriculation immatriculation : lstImma) {
                    if (!immatriculation.getTypeIdentifiant().value().equals(IMMA_NUM_EXPLOIT)) continue;
                    if (!Utils.isIdentifiantNational(immatriculation.getIdentifiant())) {
                        anomalies.add(Controle.creerAnomalie("J026", versionSchemaReference));
                    }
                    numExploit = true;
                }
                if (!numExploit) {
                    anomalies.add(Controle.creerAnomalie("J036", versionSchemaReference));
                }
            }
            anomalies.addAll(Controle.ControleDate(dechargement.getDate(), dechargement.getHeure(), versionSchemaReference));
        }
        return anomalies;
    }

    private static void ControlerCirculationOrienteeChargement(CirculationOrienteeChargement circulation, String versionSchemaReference) {
        Validation validation = circulation.getValidation();
        if (validation == null) {
            validation = new Validation();
        }
        List<Immatriculation> lstImmaCreateur = circulation.getCreateur().getImmatriculation();
        for (Immatriculation immatCrea : lstImmaCreateur) {
            if (!immatCrea.getTypeIdentifiant().value().equals(IMMA_NUM_DELEGATAIRE)) continue;
            validation.getAnomalie().add(Controle.creerAnomalie("J063", versionSchemaReference));
        }
        Chargement chargement = circulation.getChargement();
        if (chargement.isTemoinDelegation()) {
            validation.getAnomalie().add(Controle.creerAnomalie("J040", versionSchemaReference));
        }
        if (chargement.getCategorieActeur().equals(CATEGORIE_ACTEUR_10) && (circulation.getVehiculeUtilise() == null || circulation.getOrganisationTransport() == null)) {
            validation.getAnomalie().add(Controle.creerAnomalie("J044", versionSchemaReference));
        }
        List<Immatriculation> lstImma = chargement.getExploitationChargement().getImmatriculation();
        for (Immatriculation immatriculation : lstImma) {
            if (!immatriculation.getTypeIdentifiant().value().equals(IMMA_NUM_EXPLOIT)) continue;
            Organisation createur = circulation.getCreateur();
            List<Immatriculation> lstImmaCrea = createur.getImmatriculation();
            for (Immatriculation immatCrea : lstImmaCrea) {
                if (immatCrea.getTypeIdentifiant().value().equals(IMMA_CODE_MOIPG)) {
                    String identifiant = immatCrea.getIdentifiant();
                    if (identifiant.length() == 6 && identifiant.endsWith("IPG")) {
                        if (identifiant.charAt(0) == '0') {
                            if (!(identifiant.subSequence(1, 3).equals("2A") || identifiant.subSequence(1, 3).equals("2B") || identifiant.subSequence(1, 3).equals(immatriculation.getIdentifiant().substring(2, 4)))) {
                                validation.getAnomalie().add(Controle.creerAnomalie("J015", versionSchemaReference));
                            }
                            if (!identifiant.subSequence(1, 3).equals("2A") && !identifiant.subSequence(1, 3).equals("2B") || immatriculation.getIdentifiant().substring(2, 4).equals("20")) continue;
                            validation.getAnomalie().add(Controle.creerAnomalie("J015", versionSchemaReference));
                            continue;
                        }
                        if (identifiant.charAt(0) != '0' && !identifiant.subSequence(0, 3).equals("974")) {
                            if (identifiant.substring(0, 3).equals(immatriculation.getIdentifiant().substring(2, 5))) continue;
                            validation.getAnomalie().add(Controle.creerAnomalie("J015", versionSchemaReference));
                            continue;
                        }
                        if (identifiant.charAt(0) == '0' || !identifiant.subSequence(0, 3).equals("974") || immatriculation.getIdentifiant().substring(2, 4).equals("98")) continue;
                        validation.getAnomalie().add(Controle.creerAnomalie("J015", versionSchemaReference));
                        continue;
                    }
                    validation.getAnomalie().add(Controle.creerAnomalie("J015", versionSchemaReference));
                    continue;
                }
                if (immatCrea.getIdentifiant().equals(immatriculation.getIdentifiant())) continue;
                validation.getAnomalie().add(Controle.creerAnomalie("J015", versionSchemaReference));
            }
        }
        Destination destination = circulation.getDestination();
        List<Immatriculation> lstImmaDest = destination.getOrganisationDetaillee().getImmatriculation();
        if (lstImmaDest.size() > 2) {
            validation.getAnomalie().add(Controle.creerAnomalie("J058", versionSchemaReference));
        } else {
            boolean testNumeroSiren = false;
            boolean numeroSirenOk = false;
            boolean numeroExploitationOk = false;
            boolean numeroAgrementOk = false;
            if (lstImmaDest.size() == 2) {
                testNumeroSiren = true;
            }
            for (Immatriculation immatDest : lstImmaDest) {
                if (immatDest.getTypeIdentifiant().value().equals(IMMA_NUM_EXPLOIT)) {
                    numeroExploitationOk = true;
                    if (!immatDest.getIdentifiant().equals(NUM_INEXISTANT) && !Utils.isIdentifiantNational(immatDest.getIdentifiant())) {
                        validation.getAnomalie().add(Controle.creerAnomalie("J032", versionSchemaReference));
                    }
                    if (immatDest.getIdentifiant().equals(NUM_INEXISTANT)) {
                        if (destination.getOrganisationDetaillee().getAdresse() != null && destination.getOrganisationDetaillee().getPersonne() != null) {
                            Adresse adresse = destination.getOrganisationDetaillee().getAdresse();
                            Personne personne = destination.getOrganisationDetaillee().getPersonne();
                            if (adresse.getCodePostal().equals("") || adresse.getLocalite() == null || personne.getNomDeFamille() == null || personne.getPrenom() == null) {
                                validation.getAnomalie().add(Controle.creerAnomalie("J035", versionSchemaReference));
                            }
                        } else {
                            validation.getAnomalie().add(Controle.creerAnomalie("J035", versionSchemaReference));
                        }
                    }
                } else if (immatDest.getTypeIdentifiant().value().equals(IMMA_NUM_SIREN)) {
                    numeroSirenOk = true;
                    if (!Utils.isNumeroSiren(immatDest.getIdentifiant())) {
                        validation.getAnomalie().add(Controle.creerAnomalie("J030", versionSchemaReference));
                    }
                } else if (immatDest.getTypeIdentifiant().value().equals(IMMA_NUM_AGREMENT)) {
                    numeroAgrementOk = true;
                    if (!Utils.isAgrementSanitaire(immatDest.getIdentifiant())) {
                        validation.getAnomalie().add(Controle.creerAnomalie("J031", versionSchemaReference));
                    }
                } else if (immatDest.getTypeIdentifiant().value().equals(IMMA_CERTIF_UE) || immatDest.getTypeIdentifiant().value().equals(IMMA_CERTIF_PAYS_TIERS)) {
                    if (!immatDest.getIdentifiant().equals(ETRANGER)) {
                        validation.getAnomalie().add(Controle.creerAnomalie("J037", versionSchemaReference));
                    }
                    if (circulation.getDestination().getOrganisationDetaillee().getNumeroCertificat() == null || circulation.getDestination().getOrganisationDetaillee().getNumeroCertificat().equals("")) {
                        validation.getAnomalie().add(Controle.creerAnomalie("J038", versionSchemaReference));
                    }
                    if (circulation.getVehiculeUtilise() == null || circulation.getOrganisationTransport() == null) {
                        validation.getAnomalie().add(Controle.creerAnomalie("J043", versionSchemaReference));
                    }
                } else {
                    validation.getAnomalie().add(Controle.creerAnomalie("J039", versionSchemaReference));
                }
                if (!immatDest.getIdentifiant().equals(ETRANGER) || immatDest.getTypeIdentifiant().value().equals(IMMA_CERTIF_UE) || immatDest.getTypeIdentifiant().value().equals(IMMA_CERTIF_PAYS_TIERS)) continue;
                validation.getAnomalie().add(Controle.creerAnomalie("J037", versionSchemaReference));
            }
            if (testNumeroSiren && !numeroSirenOk) {
                validation.getAnomalie().add(Controle.creerAnomalie("J059", versionSchemaReference));
            }
            if (!(!numeroSirenOk || numeroExploitationOk || numeroAgrementOk || circulation.getVehiculeUtilise() != null && circulation.getOrganisationTransport() != null)) {
                validation.getAnomalie().add(Controle.creerAnomalie("J042", versionSchemaReference));
            }
            if (destination.getCategorieActeur() != null && (destination.getCategorieActeur().equals(CATEGORIE_ACTEUR_10) || destination.getCategorieActeur().equals(CATEGORIE_ACTEUR_31) || destination.getCategorieActeur().equals(CATEGORIE_ACTEUR_32)) && !numeroExploitationOk) {
                validation.getAnomalie().add(Controle.creerAnomalie("J050", versionSchemaReference));
            }
            if (destination.getCategorieActeur() != null && destination.getCategorieActeur().equals(CATEGORIE_ACTEUR_40) && !numeroAgrementOk) {
                validation.getAnomalie().add(Controle.creerAnomalie("J051", versionSchemaReference));
            }
            if (destination.getCategorieActeur() != null && destination.getCategorieActeur().equals(CATEGORIE_ACTEUR_34) && !numeroSirenOk) {
                validation.getAnomalie().add(Controle.creerAnomalie("J049", versionSchemaReference));
            }
        }
        if (circulation.getChargement() != null) {
            if (circulation.getChargement().getCategorieActeur() != null && circulation.getChargement().getCategorieActeur().matches("^[ ]*$")) {
                validation.getAnomalie().add(Controle.creerAnomalie("J141", versionSchemaReference));
            }
            if (circulation.getChargement().getExploitationChargement().getNomOrganisation() != null && circulation.getChargement().getExploitationChargement().getNomOrganisation().matches("^[ ]*$")) {
                validation.getAnomalie().add(Controle.creerAnomalie("J141", versionSchemaReference));
            }
        }
        if (circulation.getCodeAction() != null && circulation.getCodeAction().value() != null && circulation.getCodeAction().value().matches("^[ ]*$")) {
            validation.getAnomalie().add(Controle.creerAnomalie("J141", versionSchemaReference));
        }
        if (circulation.getCommentaire() != null && circulation.getCommentaire().matches("^[ ]*$")) {
            validation.getAnomalie().add(Controle.creerAnomalie("J141", versionSchemaReference));
        }
        if (circulation.getCreateur() != null && circulation.getCreateur().getNomOrganisation() != null && circulation.getCreateur().getNomOrganisation().matches("^[ ]*$")) {
            validation.getAnomalie().add(Controle.creerAnomalie("J141", versionSchemaReference));
        }
        if (circulation.getDestinataire() != null && circulation.getDestinataire().getNomOrganisation() != null && circulation.getDestinataire().getNomOrganisation().matches("^[ ]*$")) {
            validation.getAnomalie().add(Controle.creerAnomalie("J141", versionSchemaReference));
        }
        if (circulation.getDestination() != null) {
            if (circulation.getDestination().getCategorieActeur() != null && circulation.getDestination().getCategorieActeur().matches("^[ ]*$")) {
                validation.getAnomalie().add(Controle.creerAnomalie("J141", versionSchemaReference));
            }
            if (circulation.getDestination().getOrganisationDetaillee() != null) {
                if (circulation.getDestination().getOrganisationDetaillee().getAdresse() != null) {
                    if (circulation.getDestination().getOrganisationDetaillee().getAdresse().getCodePostal() != null && circulation.getDestination().getOrganisationDetaillee().getAdresse().getCodePostal().matches("^[ ]*$")) {
                        validation.getAnomalie().add(Controle.creerAnomalie("J141", versionSchemaReference));
                    }
                    if (circulation.getDestination().getOrganisationDetaillee().getAdresse().getLieuDit() != null && circulation.getDestination().getOrganisationDetaillee().getAdresse().getLieuDit().matches("^[ ]*$")) {
                        validation.getAnomalie().add(Controle.creerAnomalie("J141", versionSchemaReference));
                    }
                    if (circulation.getDestination().getOrganisationDetaillee().getAdresse().getLocalite() != null && circulation.getDestination().getOrganisationDetaillee().getAdresse().getLocalite().matches("^[ ]*$")) {
                        validation.getAnomalie().add(Controle.creerAnomalie("J141", versionSchemaReference));
                    }
                }
                if (circulation.getDestination().getOrganisationDetaillee().getNomOrganisation() != null && circulation.getDestination().getOrganisationDetaillee().getNomOrganisation().matches("^[ ]*$")) {
                    validation.getAnomalie().add(Controle.creerAnomalie("J141", versionSchemaReference));
                }
                if (circulation.getDestination().getOrganisationDetaillee().getNumeroCertificat() != null && circulation.getDestination().getOrganisationDetaillee().getNumeroCertificat().matches("^[ ]*$")) {
                    validation.getAnomalie().add(Controle.creerAnomalie("J141", versionSchemaReference));
                }
                if (circulation.getDestination().getOrganisationDetaillee().getPersonne() != null) {
                    if (circulation.getDestination().getOrganisationDetaillee().getPersonne().getAdresse() != null) {
                        if (circulation.getDestination().getOrganisationDetaillee().getPersonne().getAdresse().getCodePostal() != null && circulation.getDestination().getOrganisationDetaillee().getPersonne().getAdresse().getCodePostal().matches("^[ ]*$")) {
                            validation.getAnomalie().add(Controle.creerAnomalie("J141", versionSchemaReference));
                        }
                        if (circulation.getDestination().getOrganisationDetaillee().getPersonne().getAdresse().getLieuDit() != null && circulation.getDestination().getOrganisationDetaillee().getPersonne().getAdresse().getLieuDit().matches("^[ ]*$")) {
                            validation.getAnomalie().add(Controle.creerAnomalie("J141", versionSchemaReference));
                        }
                        if (circulation.getDestination().getOrganisationDetaillee().getPersonne().getAdresse().getLocalite() != null && circulation.getDestination().getOrganisationDetaillee().getPersonne().getAdresse().getLocalite().matches("^[ ]*$")) {
                            validation.getAnomalie().add(Controle.creerAnomalie("J141", versionSchemaReference));
                        }
                    }
                    if (circulation.getDestination().getOrganisationDetaillee().getPersonne().getNomDeFamille() != null && circulation.getDestination().getOrganisationDetaillee().getPersonne().getNomDeFamille().matches("^[ ]*$")) {
                        validation.getAnomalie().add(Controle.creerAnomalie("J141", versionSchemaReference));
                    }
                    if (circulation.getDestination().getOrganisationDetaillee().getPersonne().getPrenom() != null && circulation.getDestination().getOrganisationDetaillee().getPersonne().getPrenom().matches("^[ ]*$")) {
                        validation.getAnomalie().add(Controle.creerAnomalie("J141", versionSchemaReference));
                    }
                }
            }
        }
        if (circulation.getIdentifiant() != null && circulation.getIdentifiant().matches("^[ ]*$")) {
            validation.getAnomalie().add(Controle.creerAnomalie("J141", versionSchemaReference));
        }
        if (circulation.getOrganisationTransport() != null) {
            if (circulation.getOrganisationTransport().getNomOrganisation() != null && circulation.getOrganisationTransport().getNomOrganisation().matches("^[ ]*$")) {
                validation.getAnomalie().add(Controle.creerAnomalie("J141", versionSchemaReference));
            }
            if (circulation.getOrganisationTransport().getTypeTransporteur() != null && circulation.getOrganisationTransport().getTypeTransporteur().value() != null && circulation.getOrganisationTransport().getTypeTransporteur().value().matches("^[ ]*$")) {
                validation.getAnomalie().add(Controle.creerAnomalie("J141", versionSchemaReference));
            }
        }
        if (circulation.getVehiculeUtilise() != null) {
            if (circulation.getVehiculeUtilise().getNumeroMineralogique() != null && circulation.getVehiculeUtilise().getNumeroMineralogique().matches("^[ ]*$")) {
                validation.getAnomalie().add(Controle.creerAnomalie("J141", versionSchemaReference));
            }
            if (circulation.getVehiculeUtilise().getTypeVehicule() != null && circulation.getVehiculeUtilise().getTypeVehicule().matches("^[ ]*$")) {
                validation.getAnomalie().add(Controle.creerAnomalie("J141", versionSchemaReference));
            }
        }
        validation.setQualification(validation.getAnomalie().size() == 0);
        circulation.setValidation(validation);
    }

    private static void ControlerCirculationOrienteeDechargement(CirculationOrienteeDechargement circulation, String versionSchemaReference) {
        Validation validation = circulation.getValidation();
        if (validation == null) {
            validation = new Validation();
        }
        List<Immatriculation> lstImmaCreateur = circulation.getCreateur().getImmatriculation();
        for (Immatriculation immatCrea : lstImmaCreateur) {
            if (!immatCrea.getTypeIdentifiant().value().equals(IMMA_NUM_DELEGATAIRE)) continue;
            validation.getAnomalie().add(Controle.creerAnomalie("J064", versionSchemaReference));
        }
        Dechargement dechargement = circulation.getDechargement();
        if (dechargement.isTemoinDelegation()) {
            validation.getAnomalie().add(Controle.creerAnomalie("J041", versionSchemaReference));
        }
        if (dechargement.getCategorieActeur().equals(CATEGORIE_ACTEUR_10) && (circulation.getVehiculeUtilise() == null || circulation.getOrganisationTransport() == null)) {
            validation.getAnomalie().add(Controle.creerAnomalie("J046", versionSchemaReference));
        }
        List<Immatriculation> lstImma = dechargement.getExploitationDeDechargement().getImmatriculation();
        for (Immatriculation immatriculation : lstImma) {
            if (!immatriculation.getTypeIdentifiant().value().equals(IMMA_NUM_EXPLOIT)) continue;
            Organisation createur = circulation.getCreateur();
            List<Immatriculation> lstImmaCrea = createur.getImmatriculation();
            for (Immatriculation immatCrea : lstImmaCrea) {
                if (immatCrea.getTypeIdentifiant().value().equals(IMMA_CODE_MOIPG)) {
                    String identifiant = immatCrea.getIdentifiant();
                    if (identifiant.length() == 6 && identifiant.endsWith("IPG")) {
                        if (identifiant.charAt(0) == '0') {
                            if (!(identifiant.subSequence(1, 3).equals("2A") || identifiant.subSequence(1, 3).equals("2B") || identifiant.subSequence(1, 3).equals(immatriculation.getIdentifiant().substring(2, 4)))) {
                                validation.getAnomalie().add(Controle.creerAnomalie("J016", versionSchemaReference));
                            }
                            if (!identifiant.subSequence(1, 3).equals("2A") && !identifiant.subSequence(1, 3).equals("2B") || immatriculation.getIdentifiant().substring(2, 4).equals("20")) continue;
                            validation.getAnomalie().add(Controle.creerAnomalie("J016", versionSchemaReference));
                            continue;
                        }
                        if (identifiant.charAt(0) != '0' && !identifiant.subSequence(0, 3).equals("974")) {
                            if (identifiant.substring(0, 3).equals(immatriculation.getIdentifiant().substring(2, 5))) continue;
                            validation.getAnomalie().add(Controle.creerAnomalie("J016", versionSchemaReference));
                            continue;
                        }
                        if (identifiant.charAt(0) == '0' || !identifiant.subSequence(0, 3).equals("974") || immatriculation.getIdentifiant().substring(2, 4).equals("98")) continue;
                        validation.getAnomalie().add(Controle.creerAnomalie("J016", versionSchemaReference));
                        continue;
                    }
                    validation.getAnomalie().add(Controle.creerAnomalie("J016", versionSchemaReference));
                    continue;
                }
                if (immatCrea.getIdentifiant().equals(immatriculation.getIdentifiant())) continue;
                validation.getAnomalie().add(Controle.creerAnomalie("J016", versionSchemaReference));
            }
        }
        Provenance provenance = circulation.getProvenance();
        List<Immatriculation> lstImmaDest = provenance.getOrganisationDetaillee().getImmatriculation();
        if (lstImmaDest.size() > 2) {
            validation.getAnomalie().add(Controle.creerAnomalie("J058", versionSchemaReference));
        } else {
            boolean testNumeroSiren = false;
            boolean numeroSirenOk = false;
            boolean numeroExploitationOk = false;
            boolean numeroInexistantOk = false;
            if (lstImmaDest.size() == 2) {
                testNumeroSiren = true;
            }
            for (Immatriculation immatDest : lstImmaDest) {
                if (immatDest.getTypeIdentifiant().value().equals(IMMA_NUM_EXPLOIT)) {
                    numeroExploitationOk = true;
                    if (!immatDest.getIdentifiant().equals(NUM_INEXISTANT) && !Utils.isIdentifiantNational(immatDest.getIdentifiant())) {
                        validation.getAnomalie().add(Controle.creerAnomalie("J033", versionSchemaReference));
                    }
                    if (immatDest.getIdentifiant().equals(NUM_INEXISTANT)) {
                        numeroInexistantOk = true;
                    }
                } else if (immatDest.getTypeIdentifiant().value().equals(IMMA_NUM_SIREN)) {
                    numeroSirenOk = true;
                    if (!Utils.isNumeroSiren(immatDest.getIdentifiant())) {
                        validation.getAnomalie().add(Controle.creerAnomalie("J030", versionSchemaReference));
                    }
                } else if (immatDest.getTypeIdentifiant().value().equals(IMMA_CERTIF_UE) || immatDest.getTypeIdentifiant().value().equals(IMMA_CERTIF_PAYS_TIERS)) {
                    if (!immatDest.getIdentifiant().equals(ETRANGER)) {
                        validation.getAnomalie().add(Controle.creerAnomalie("J037", versionSchemaReference));
                    }
                    if (circulation.getProvenance().getOrganisationDetaillee().getNumeroCertificat() == null || circulation.getProvenance().getOrganisationDetaillee().getNumeroCertificat().equals("")) {
                        validation.getAnomalie().add(Controle.creerAnomalie("J038", versionSchemaReference));
                    }
                    if (circulation.getVehiculeUtilise() == null || circulation.getOrganisationTransport() == null) {
                        validation.getAnomalie().add(Controle.creerAnomalie("J054", versionSchemaReference));
                    }
                } else {
                    validation.getAnomalie().add(Controle.creerAnomalie("J048", versionSchemaReference));
                }
                if (immatDest.getIdentifiant().equals(ETRANGER) && !immatDest.getTypeIdentifiant().value().equals(IMMA_CERTIF_UE) && !immatDest.getTypeIdentifiant().value().equals(IMMA_CERTIF_PAYS_TIERS)) {
                    validation.getAnomalie().add(Controle.creerAnomalie("J037", versionSchemaReference));
                }
                if (!immatDest.getTypeIdentifiant().value().equals(IMMA_NUM_EXPLOIT) || !immatDest.getIdentifiant().equals(NUM_INEXISTANT)) continue;
                if (provenance.getOrganisationDetaillee().getAdresse() != null) {
                    if (provenance.getOrganisationDetaillee().getAdresse().getCodePostal() == null || "".equals(provenance.getOrganisationDetaillee().getAdresse().getCodePostal())) {
                        validation.getAnomalie().add(Controle.creerAnomalie("J142", versionSchemaReference));
                    }
                    if (provenance.getOrganisationDetaillee().getAdresse().getLocalite() == null || "".equals(provenance.getOrganisationDetaillee().getAdresse().getLocalite())) {
                        validation.getAnomalie().add(Controle.creerAnomalie("J142", versionSchemaReference));
                    }
                } else {
                    validation.getAnomalie().add(Controle.creerAnomalie("J142", versionSchemaReference));
                }
                if (provenance.getOrganisationDetaillee().getPersonne() != null) {
                    if (provenance.getOrganisationDetaillee().getPersonne().getNomDeFamille() == null || "".equals(provenance.getOrganisationDetaillee().getPersonne().getNomDeFamille())) {
                        validation.getAnomalie().add(Controle.creerAnomalie("J142", versionSchemaReference));
                    }
                    if (provenance.getOrganisationDetaillee().getPersonne().getPrenom() != null && !"".equals(provenance.getOrganisationDetaillee().getPersonne().getPrenom())) continue;
                    validation.getAnomalie().add(Controle.creerAnomalie("J142", versionSchemaReference));
                    continue;
                }
                validation.getAnomalie().add(Controle.creerAnomalie("J142", versionSchemaReference));
            }
            if (testNumeroSiren && !numeroSirenOk) {
                validation.getAnomalie().add(Controle.creerAnomalie("J059", versionSchemaReference));
            }
            if (numeroSirenOk && !numeroExploitationOk && (circulation.getVehiculeUtilise() == null || circulation.getOrganisationTransport() == null)) {
                validation.getAnomalie().add(Controle.creerAnomalie("J053", versionSchemaReference));
            }
            if (provenance.getCategorieActeur() != null && (provenance.getCategorieActeur().equals(CATEGORIE_ACTEUR_10) || provenance.getCategorieActeur().equals(CATEGORIE_ACTEUR_31) || provenance.getCategorieActeur().equals(CATEGORIE_ACTEUR_32)) && !numeroExploitationOk) {
                validation.getAnomalie().add(Controle.creerAnomalie("J055", versionSchemaReference));
            }
            if (provenance.getCategorieActeur() != null && provenance.getCategorieActeur().equals(CATEGORIE_ACTEUR_34) && !numeroSirenOk) {
                validation.getAnomalie().add(Controle.creerAnomalie("J056", versionSchemaReference));
            }
            if (!dechargement.getCategorieActeur().equals(CATEGORIE_ACTEUR_40) && numeroExploitationOk && numeroInexistantOk) {
                validation.getAnomalie().add(Controle.creerAnomalie("J057", versionSchemaReference));
            }
        }
        if (!(provenance.getCategorieActeur() == null || provenance.getCategorieActeur().equals(CATEGORIE_ACTEUR_10) || provenance.getCategorieActeur().equals(CATEGORIE_ACTEUR_31) || provenance.getCategorieActeur().equals(CATEGORIE_ACTEUR_32) || provenance.getCategorieActeur().equals(CATEGORIE_ACTEUR_34))) {
            validation.getAnomalie().add(Controle.creerAnomalie("J034", versionSchemaReference));
        }
        if (circulation.getDechargement() != null) {
            if (circulation.getDechargement().getCategorieActeur() != null && circulation.getDechargement().getCategorieActeur().matches("^[ ]*$")) {
                validation.getAnomalie().add(Controle.creerAnomalie("J141", versionSchemaReference));
            }
            if (circulation.getDechargement().getExploitationDeDechargement() != null && circulation.getDechargement().getExploitationDeDechargement().getNomOrganisation() != null && circulation.getDechargement().getExploitationDeDechargement().getNomOrganisation().matches("^[ ]*$")) {
                validation.getAnomalie().add(Controle.creerAnomalie("J141", versionSchemaReference));
            }
        }
        if (circulation.getCodeAction() != null && circulation.getCodeAction().value() != null && circulation.getCodeAction().value().matches("^[ ]*$")) {
            validation.getAnomalie().add(Controle.creerAnomalie("J141", versionSchemaReference));
        }
        if (circulation.getCommentaire() != null && circulation.getCommentaire().matches("^[ ]*$")) {
            validation.getAnomalie().add(Controle.creerAnomalie("J141", versionSchemaReference));
        }
        if (circulation.getCreateur() != null && circulation.getCreateur().getNomOrganisation() != null && circulation.getCreateur().getNomOrganisation().matches("^[ ]*$")) {
            validation.getAnomalie().add(Controle.creerAnomalie("J141", versionSchemaReference));
        }
        if (circulation.getDestinataire() != null && circulation.getDestinataire().getNomOrganisation() != null && circulation.getDestinataire().getNomOrganisation().matches("^[ ]*$")) {
            validation.getAnomalie().add(Controle.creerAnomalie("J141", versionSchemaReference));
        }
        if (circulation.getProvenance() != null) {
            if (circulation.getProvenance().getCategorieActeur() != null && circulation.getProvenance().getCategorieActeur().matches("^[ ]*$")) {
                validation.getAnomalie().add(Controle.creerAnomalie("J141", versionSchemaReference));
            }
            if (circulation.getProvenance().getOrganisationDetaillee() != null) {
                if (circulation.getProvenance().getOrganisationDetaillee().getAdresse() != null) {
                    if (circulation.getProvenance().getOrganisationDetaillee().getAdresse().getCodePostal() != null && circulation.getProvenance().getOrganisationDetaillee().getAdresse().getCodePostal().matches("^[ ]*$")) {
                        validation.getAnomalie().add(Controle.creerAnomalie("J141", versionSchemaReference));
                    }
                    if (circulation.getProvenance().getOrganisationDetaillee().getAdresse().getLieuDit() != null && circulation.getProvenance().getOrganisationDetaillee().getAdresse().getLieuDit().matches("^[ ]*$")) {
                        validation.getAnomalie().add(Controle.creerAnomalie("J141", versionSchemaReference));
                    }
                    if (circulation.getProvenance().getOrganisationDetaillee().getAdresse().getLocalite() != null && circulation.getProvenance().getOrganisationDetaillee().getAdresse().getLocalite().matches("^[ ]*$")) {
                        validation.getAnomalie().add(Controle.creerAnomalie("J141", versionSchemaReference));
                    }
                }
                if (circulation.getProvenance().getOrganisationDetaillee().getNomOrganisation() != null && circulation.getProvenance().getOrganisationDetaillee().getNomOrganisation().matches("^[ ]*$")) {
                    validation.getAnomalie().add(Controle.creerAnomalie("J141", versionSchemaReference));
                }
                if (circulation.getProvenance().getOrganisationDetaillee().getNumeroCertificat() != null && circulation.getProvenance().getOrganisationDetaillee().getNumeroCertificat().matches("^[ ]*$")) {
                    validation.getAnomalie().add(Controle.creerAnomalie("J141", versionSchemaReference));
                }
                if (circulation.getProvenance().getOrganisationDetaillee().getPersonne() != null) {
                    if (circulation.getProvenance().getOrganisationDetaillee().getPersonne().getAdresse() != null) {
                        if (circulation.getProvenance().getOrganisationDetaillee().getPersonne().getAdresse().getCodePostal() != null && circulation.getProvenance().getOrganisationDetaillee().getPersonne().getAdresse().getCodePostal().matches("^[ ]*$")) {
                            validation.getAnomalie().add(Controle.creerAnomalie("J141", versionSchemaReference));
                        }
                        if (circulation.getProvenance().getOrganisationDetaillee().getPersonne().getAdresse().getLieuDit() != null && circulation.getProvenance().getOrganisationDetaillee().getPersonne().getAdresse().getLieuDit().matches("^[ ]*$")) {
                            validation.getAnomalie().add(Controle.creerAnomalie("J141", versionSchemaReference));
                        }
                        if (circulation.getProvenance().getOrganisationDetaillee().getPersonne().getAdresse().getLocalite() != null && circulation.getProvenance().getOrganisationDetaillee().getPersonne().getAdresse().getLocalite().matches("^[ ]*$")) {
                            validation.getAnomalie().add(Controle.creerAnomalie("J141", versionSchemaReference));
                        }
                    }
                    if (circulation.getProvenance().getOrganisationDetaillee().getPersonne().getNomDeFamille() != null && circulation.getProvenance().getOrganisationDetaillee().getPersonne().getNomDeFamille().matches("^[ ]*$")) {
                        validation.getAnomalie().add(Controle.creerAnomalie("J141", versionSchemaReference));
                    }
                    if (circulation.getProvenance().getOrganisationDetaillee().getPersonne().getPrenom() != null && circulation.getProvenance().getOrganisationDetaillee().getPersonne().getPrenom().matches("^[ ]*$")) {
                        validation.getAnomalie().add(Controle.creerAnomalie("J141", versionSchemaReference));
                    }
                }
            }
        }
        if (circulation.getIdentifiant() != null && circulation.getIdentifiant().matches("^[ ]*$")) {
            validation.getAnomalie().add(Controle.creerAnomalie("J141", versionSchemaReference));
        }
        if (circulation.getOrganisationTransport() != null) {
            if (circulation.getOrganisationTransport().getNomOrganisation() != null && circulation.getOrganisationTransport().getNomOrganisation().matches("^[ ]*$")) {
                validation.getAnomalie().add(Controle.creerAnomalie("J141", versionSchemaReference));
            }
            if (circulation.getOrganisationTransport().getTypeTransporteur() != null && circulation.getOrganisationTransport().getTypeTransporteur().value() != null && circulation.getOrganisationTransport().getTypeTransporteur().value().matches("^[ ]*$")) {
                validation.getAnomalie().add(Controle.creerAnomalie("J141", versionSchemaReference));
            }
        }
        if (circulation.getVehiculeUtilise() != null) {
            if (circulation.getVehiculeUtilise().getNumeroMineralogique() != null && circulation.getVehiculeUtilise().getNumeroMineralogique().matches("^[ ]*$")) {
                validation.getAnomalie().add(Controle.creerAnomalie("J141", versionSchemaReference));
            }
            if (circulation.getVehiculeUtilise().getTypeVehicule() != null && circulation.getVehiculeUtilise().getTypeVehicule().matches("^[ ]*$")) {
                validation.getAnomalie().add(Controle.creerAnomalie("J141", versionSchemaReference));
            }
        }
        validation.setQualification(validation.getAnomalie().size() == 0);
        circulation.setValidation(validation);
    }

    private static Anomalie creerAnomalie(String codeErreur, String versionSchemaReference) {
        Anomalie anomalie = new Anomalie();
        anomalie.setCodeAnomalie(OCAnomalyCodeType.fromValue(codeErreur));
        anomalie.setTypeAnomalie("1");
        anomalie.setLibelleAnomalie(MsgErr.getMsgErr(codeErreur, versionSchemaReference));
        return anomalie;
    }

    private static List<Anomalie> ControleDate(XMLGregorianCalendar date, XMLGregorianCalendar heure, String versionSchemaReference) {
        ArrayList<Anomalie> anomalies = new ArrayList<Anomalie>();
        XMLGregorianCalendar dateHeure = null;
        if (date != null) {
            dateHeure = (XMLGregorianCalendar)date.clone();
            if (heure != null) {
                dateHeure.setTimezone(heure.getTimezone());
                dateHeure.setTime(heure.getHour(), heure.getMinute(), heure.getSecond());
            }
            if (dateCreation.compare(dateHeure) == -1) {
                anomalies.add(Controle.creerAnomalie("J052", versionSchemaReference));
            }
        }
        return anomalies;
    }

    static {
        codesEmetteur = new ArrayList<String>();
        codesCreateur = new ArrayList<String>();
        emmetteursCreateurs = new HashMap();
        HashSet<String> tmpEm = new HashSet<String>();
        HashSet<String> tmpCr = new HashSet<String>();
        ResourceBundle bundle = null;
        try {
            String valeur = null;
            String[] codes = null;
            bundle = ResourceBundle.getBundle(FILE_NAME);
            Enumeration<String> keys = bundle.getKeys();
            while (keys.hasMoreElements()) {
                String key = keys.nextElement();
                if (key == null) continue;
                ArrayList<String> lstTmp = new ArrayList<String>();
                tmpEm.add(key);
                valeur = bundle.getString(key);
                for (String code : codes = valeur.split(",")) {
                    tmpCr.add(code);
                    lstTmp.add(code);
                }
                emmetteursCreateurs.put(key, lstTmp);
            }
            codesEmetteur.addAll(tmpEm);
            codesCreateur.addAll(tmpCr);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

