/*
 * Decompiled with CFR 0.152.
 */
package com;

import com.teamlog.simoc.xml.Controle;
import com.teamlog.simoc.xml.MsgErr;
import com.teamlog.simoc.xml.XmlUtils;
import com.teamlog.simoc.xmlObject.NotificationMouvementLotOvinCaprin;
import fr.okteo.simoc.xml.V2.ControleV2;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.ResourceBundle;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ConfoSimoc {
    private static final Logger logger = LogManager.getLogger(ConfoSimoc.class);
    static final String REP_TRAVAIL_DEFAUT = "validation";
    static final String REP_XSD_V111 = "xsd";
    static final String REP_XSD_V2 = "xsd_V2";
    static final String FICHIER_XSD_V111 = "XMLNotificationOvinCaprinV111.XSD";
    static final String FICHIER_XSD_V2 = "XMLNotificationOvinCaprinV2.XSD";
    private static File repTravail = null;
    private static File fichierXsd = null;
    private static File fichierXsdV111 = null;
    private static File fichierXsdV2 = null;
    private static String versionSchemaReference = null;
    private static Boolean dateV2depassee = null;
    private static final String FILE_NAME = "confosimoc";
    private static ResourceBundle bundle = null;

    public static void main(String[] args) {
        if (ConfoSimoc.Initialisation(args)) {
            File[] fichiers;
            JAXBContext jc = null;
            try {
                jc = JAXBContext.newInstance("com.teamlog.simoc.xmlObject");
            }
            catch (JAXBException e) {
                logger.error(e.getMessage());
                System.exit(1);
            }
            JAXBContext jcV2 = null;
            try {
                jcV2 = JAXBContext.newInstance("fr.okteo.simoc.xmlObject.V2");
            }
            catch (JAXBException e) {
                logger.error(e.getMessage());
                System.exit(1);
            }
            for (File fichier : fichiers = repTravail.listFiles()) {
                File nomFichierLog;
                String nomSansExtension;
                NotificationMouvementLotOvinCaprin mvtOC = null;
                fr.okteo.simoc.xmlObject.V2.NotificationMouvementLotOvinCaprin mvtOCV2 = null;
                ArrayList<String> erreurs = new ArrayList<String>();
                ArrayList<String> anomalies = new ArrayList<String>();
                boolean fichierValide = false;
                try {
                    logger.debug("Traitement du fichier : " + fichier.getName());
                    logger.debug("[1] Recherche du sch\u00e9ma de r\u00e9f\u00e9rence du fichier xml");
                    versionSchemaReference = XmlUtils.rechercherSchemaReference(fichier.getPath(), erreurs);
                    fichierXsd = versionSchemaReference != null && "V111".equals(versionSchemaReference) && dateV2depassee == false ? fichierXsdV111 : (versionSchemaReference != null && "V2".equals(versionSchemaReference) ? fichierXsdV2 : null);
                    if (fichierXsd != null) {
                        if (XmlUtils.formatNomFichierValide(fichier.getName(), ".xml")) {
                            logger.debug("[2] Contr\u00f4le des codes ASCII");
                            if (XmlUtils.ControlerCodeASCII(fichier.getPath(), erreurs, versionSchemaReference)) {
                                logger.debug("[3] Conversion du fichier xml");
                                if ("V111".equals(versionSchemaReference)) {
                                    mvtOC = XmlUtils.lireFichierXML(jc, fichier.getPath(), fichierXsd.getAbsolutePath(), erreurs, versionSchemaReference);
                                } else if ("V2".equals(versionSchemaReference)) {
                                    mvtOCV2 = XmlUtils.lireFichierXMLV2(jcV2, fichier.getPath(), fichierXsd.getAbsolutePath(), erreurs, versionSchemaReference);
                                }
                                logger.debug("[4] Contr\u00f4le de coh\u00e9rence des donn\u00e9es");
                                if (mvtOC != null && Controle.VerifierCoherence(mvtOC, erreurs, fichier.getName(), versionSchemaReference)) {
                                    fichierValide = true;
                                }
                                if (mvtOCV2 != null && ControleV2.VerifierCoherence(mvtOCV2, erreurs, fichier.getName(), versionSchemaReference, dateV2depassee)) {
                                    fichierValide = true;
                                }
                            }
                        } else {
                            logger.debug("Rejet du fichier " + fichier.getName() + " : erreur de nommage");
                            erreurs.add("erreur de nommage");
                            fichierValide = false;
                        }
                    } else {
                        erreurs.add(MsgErr.getMsgErr("JG920", versionSchemaReference));
                        fichierValide = false;
                    }
                }
                catch (Exception e) {
                    StackTraceElement[] st;
                    logger.error("Erreur inattendue sur le fichier " + fichier.getName());
                    logger.error(e.toString());
                    StringBuffer sb = new StringBuffer();
                    for (StackTraceElement stackTraceElement : st = e.getStackTrace()) {
                        sb.append(stackTraceElement.toString()).append(System.getProperty("line.separator"));
                    }
                    logger.error(sb.toString());
                    erreurs.add("Erreur inattendue");
                }
                if (!fichierValide) {
                    nomSansExtension = fichier.getName().substring(0, fichier.getName().length() - 4);
                    if (erreurs.size() == 0) {
                        GregorianCalendar gCalendar;
                        Date date;
                        File nomFichierRep = new File(repTravail.getAbsolutePath(), nomSansExtension + "_REP.xml");
                        logger.debug("Cr\u00e9ation du fichier de r\u00e9ponse " + nomFichierRep.getPath());
                        if (mvtOC != null) {
                            mvtOC.setIdentification(nomFichierRep.getName());
                            mvtOC.setDocumentOrigine(fichier.getName());
                            date = new Date();
                            gCalendar = new GregorianCalendar();
                            gCalendar.setTime(date);
                            try {
                                DatatypeFactory dtf = DatatypeFactory.newInstance();
                                XMLGregorianCalendar xmlCalendar = dtf.newXMLGregorianCalendar(gCalendar);
                                mvtOC.setCreation(xmlCalendar);
                            }
                            catch (DatatypeConfigurationException e) {
                                logger.debug(e.getMessage());
                            }
                            logger.debug("Re\u00e9criture du fichier xml " + nomFichierRep.getName());
                            XmlUtils.ecrireFichierXML(jc, mvtOC, nomFichierRep.getPath());
                        }
                        if (mvtOCV2 != null) {
                            mvtOCV2.setIdentification(nomFichierRep.getName());
                            mvtOCV2.setDocumentOrigine(fichier.getName());
                            date = new Date();
                            gCalendar = new GregorianCalendar();
                            gCalendar.setTime(date);
                            try {
                                DatatypeFactory dtf = DatatypeFactory.newInstance();
                                XMLGregorianCalendar xmlCalendar = dtf.newXMLGregorianCalendar(gCalendar);
                                mvtOCV2.setCreation(xmlCalendar);
                            }
                            catch (DatatypeConfigurationException e) {
                                logger.debug(e.getMessage());
                            }
                            logger.debug("Re\u00e9criture du fichier xml " + nomFichierRep.getName());
                            XmlUtils.ecrireFichierXMLV2(jc, mvtOCV2, nomFichierRep.getPath());
                        }
                    } else {
                        nomFichierLog = new File(repTravail.getAbsolutePath(), nomSansExtension + "_ERR.txt");
                        logger.debug("Ecriture du fichier log " + nomFichierLog.getPath());
                        XmlUtils.EcrireFichierLog(nomFichierLog.getPath(), erreurs);
                    }
                }
                if (versionSchemaReference == null || !"V111".equals(versionSchemaReference) || dateV2depassee.booleanValue()) continue;
                nomSansExtension = fichier.getName().substring(0, fichier.getName().length() - 4);
                nomFichierLog = new File(repTravail.getAbsolutePath(), nomSansExtension + "_ANO.txt");
                logger.debug("Ecriture du fichier log " + nomFichierLog.getPath());
                anomalies.add(bundle.getString("A001"));
                XmlUtils.EcrireFichierLog(nomFichierLog.getPath(), anomalies);
            }
        } else {
            System.exit(1);
        }
        System.exit(0);
    }

    private static boolean Initialisation(String[] args) {
        boolean resultat = true;
        if (args.length > 1) {
            logger.error("Nombre de param\u00e8tres de l'application invalide.");
            resultat = false;
        } else if (args.length == 1) {
            File arg = new File(args[0]);
            if (!arg.isDirectory() && !arg.isFile()) {
                logger.error("Le param\u00e8tre [" + args[0] + "] n'est ni un r\u00e9pertoire ni un fichier valide.");
                resultat = false;
            } else if (arg.isDirectory()) {
                repTravail = new File(args[0]);
            }
        } else {
            repTravail = new File(REP_TRAVAIL_DEFAUT);
        }
        fichierXsdV111 = new File(REP_XSD_V111, FICHIER_XSD_V111);
        if (!fichierXsdV111.exists()) {
            logger.error("Le r\u00e9pertoire " + fichierXsdV111.getAbsolutePath() + " n'existe pas.");
            resultat = false;
        }
        if (!(fichierXsdV2 = new File(REP_XSD_V2, FICHIER_XSD_V2)).exists()) {
            logger.error("Le r\u00e9pertoire " + fichierXsdV2.getAbsolutePath() + " n'existe pas.");
            resultat = false;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
        Date dateTraitement = null;
        Date dateV2 = null;
        try {
            dateTraitement = sdf.parse(sdf.format(new Date()));
            dateV2 = sdf.parse(bundle.getString("DATE_V2"));
            dateV2depassee = dateTraitement.compareTo(dateV2) >= 0 ? Boolean.valueOf(true) : Boolean.valueOf(false);
        }
        catch (Exception e1) {
            logger.error("Erreur lors de la recherche si sch\u00e9ma de r\u00e9f\u00e9rence V111 autoris\u00e9");
            resultat = false;
        }
        return resultat;
    }

    static {
        try {
            bundle = ResourceBundle.getBundle(FILE_NAME);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Erreur lors de la r\u00e9cup\u00e9ration dans le fichier de config confosimoc");
        }
    }
}

